/*
 * dia_RoutineCtrlGNSSCalcAndVerifyChecksum.cpp
 *
 *  Created on: 31.07.2014
 *      Author: bhs1hi
 *
 *   --------------------------------------------------------------------------------------
 *      Date        Author      Modification
 *
 *    21.03.2016    bsu9kor     CMG3GB-3148.
 *   --------------------------------------------------------------------------------------
 */
 // TTFis: DIA_REQ UDS 04 31 01 30 69

#ifndef __INCLUDED_DIA_RTCTRL_GNSS_CALC_VERIFY_CHECKSUM_H_
#include "dia_RoutineCtrlGNSSCalcAndVerifyChecksum.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

//------------------------------------------------------------------------------

namespace dia
{

RoutineCtrlGNSSCalcAndVerifyChecksum::RoutineCtrlGNSSCalcAndVerifyChecksum ( void )
   : dia_Routine("dia_RoutineCtrlGNSSCalcAndVerifyChecksum", DIA_C_U16_DID_RBCM_RTCTRL_GNSS_FIRMWARE_CHECKSUM, DIA_EN_RTCTRL_ID_GNSS_FIRMWARE,DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::dia_RoutineCtrlGNSSCalcAndVerifyChecksum()");
}
//------------------------------------------------------------------------------

RoutineCtrlGNSSCalcAndVerifyChecksum::~RoutineCtrlGNSSCalcAndVerifyChecksum ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_RoutineCtrlGNSSCalcAndVerifyChecksum::~dia_RoutineCtrlGNSSCalcAndVerifyChecksum !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}
//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlGNSSCalcAndVerifyChecksum::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::start()");
   tDiaResult retCode = DIA_FAILED;
   // prepare processing of the routine
   vInitialize();
/*   if ( params.size() < 4 Byte )
   {
      DIA_TR_ERR("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::start INVALID PARAMETERS, Length=%d instead of =4 .", params.size());
      return DIA_FAILED;
   }*/

   for(tU8 i=0; i<params.size(); i++){
      DIA_TR_INF("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::start input param at(%d) = 0x%02x .", i, params.at(i));
   }
   dia_IGNSS* pInterface = OSAL_NULL;
   if (querySysAdapterInterface<dia_IGNSS>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (void) setSysAdapterListener<dia_IGNSSListener>(this);
         if (pInterface->getGNSSConfigData() == DIA_SUCCESS) {
            DIA_TR_INF("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::start getGNSSConfigData SUCCESS.");
            eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
            retCode = DIA_SUCCESS;
         } else {
            DIA_TR_INF("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::start getGNSSConfigData FAILED!");
            DIA_TR_ERR("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::start SEND TO SENSOR SERVER FAILED!!!!");
         }
      }
   } else {
      DIA_TR_ERR("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::start - diaResult FAILED!!!!");
   }
   return retCode;
}
//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlGNSSCalcAndVerifyChecksum::requestResult ( std::vector<tU8>& results )
{
   dia::ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());
   results.insert(results.end(), mResults.begin(), mResults.end());

   return DIA_SUCCESS;
}
//------------------------------------------------------------------------------

void
RoutineCtrlGNSSCalcAndVerifyChecksum::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::vOnServiceTimeout()");
   (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
}

//------------------------------------------------------------------------------

void
RoutineCtrlGNSSCalcAndVerifyChecksum::vOnGNSSRecFrimwareCrc ( const tU32 firmwareCrc )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::vOnGNSSRecFrimwareCrc()");

   DIA_TR_INF("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::vOnGNSSRecFrimwareCrc firmwareCrc = %d.", ((tU32)firmwareCrc));
   DIA_TR_INF("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::vOnGNSSRecFrimwareCrc firmwareCrc = 0x%08X.", firmwareCrc);
   // set Status (eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);)
   eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   // Sending back the positive answer
   DIA_TR_INF("=====================================================");
   DIA_TR_INF("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::vOnGNSSRecFrimwareCrc Answer-Buffer:");
   DIA_TR_INF("=====================================================");
   DIA_TR_INF("dia_RoutineCtrlGNSSCalcAndVerifyChecksum::vOnGNSSRecFrimwareCrc SUCCESSFUL.");
   mResults.clear();
   // Push result into Result Vector
   mResults.push_back((tU8) U32_BYTE1(firmwareCrc));
   mResults.push_back((tU8) U32_BYTE2(firmwareCrc));
   mResults.push_back((tU8) U32_BYTE3(firmwareCrc));
   mResults.push_back((tU8) U32_BYTE4(firmwareCrc));
   // set the verdict
   mResults.push_back(0x02);  // n.a. (If a verdict is not possible due missing reference information e.g. NAVI download by SD card.)
   // Variable for Service Handler Framework that this job is done //! indicate that we are done
   mIsResultReady = TRUE;
   // disconnect interface
   (void) unsetSysAdapterListener<dia_IGNSSListener>(this);
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

} //namespace dia
