/************************************************************************
* FILE:         dia_RoutineCtrlDisplayTestScreenSlideshow.cpp
* PROJECT:      GM NexGen
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service StressTest
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 10.11.14  | BSOT Plischke           | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include <common/framework/application/dia_common_core.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include <common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include <common/framework/config/dia_ConfigManager.h>
#endif


#include "dia_RoutineCtrlDisplayTestScreenSlideshow.h"


#define ROUTINE_OK         0
#define ROUTINE_NOK        1
#define ROUTINE_ABORTED    2
#define ROUTINE_RUNNING    3
#define ROUTINE_STOPPED    4


dia_RoutineCtrlDisplayTestScreenSlideshow::dia_RoutineCtrlDisplayTestScreenSlideshow()
      : dia_Routine("dia_RoutineCtrlDisplayTestScreenSlideshow", DIA_C_U16_DID_DIAGNOSIS_DISPLAY_SLIDESHOW, DIA_EN_RTCTRL_ID_DIAG_DIAGNOSIS_DISPLAY_SLIDESHOW, DIA_EN_RTCTRL_TYPE_SHORT_TERM),
        delay(0),
        isRunning(false),
        currentTestscreen(0),
        numberOfTestScreens(0),
        statusResponse(ROUTINE_STOPPED)
{
    dia_tclFnctTrace oTrace("dia_RoutineCtrlDisplayTestScreenSlideshow::dia_RoutineCtrlDisplayTestScreenSlideshow");
}

//------------------------------------------------------------------------------

dia_RoutineCtrlDisplayTestScreenSlideshow::~dia_RoutineCtrlDisplayTestScreenSlideshow()
{
#if 0 // gib2hi: disabled as dia_IHMI/dia_IHMIListener are project specific interfaces
    _BP_TRY_BEGIN
    {
        (tVoid) unsetSysAdapterListener<dia_IHmiListener>(this);
    }
    _BP_CATCH_ALL
    {
       DIA_TR_ERR("dia_RoutineCtrlDisplayTestScreenSlideshow::~dia_RoutineCtrlDisplayTestScreenSlideshow - Exception caught!");
       DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
#endif
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlDisplayTestScreenSlideshow::start ( std::vector<tU8>& /*params*/, tU8 /*timerValue*/ )
{
#if 0 // gib2hi: disabled as dia_IHMI/dia_IHMIListener are project specific interfaces

   tDiaResult  retCode         = DIA_E_CONDITIONS_NOT_CORRECT;

   tU32 size = params.size();
   if(size < 4)
   {
      DIA_TR_ERR("!!! dia_RoutineCtrlDisplayTestScreenSlideshow::start => Size mismatch size=%d",size);
      retCode = DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
   }
   else
   {
      const std::vector<tU8> paramsArray = params;
//      delay = (((tU32) params[0]) << 24) | (((tU32) params[1]) << 16) | (((tU32) params[2]) << 8) | ((tU32) params[3]);
      delay = U8_2_U32(paramsArray[0],paramsArray[1],paramsArray[2],paramsArray[3]);
      DIA_TR_INF("--- dia_RoutineCtrlDisplayTestScreenSlideshow::start => Delay:%d",delay);

      // first check size and so calculate Testscreen Data
      if(size== 4)
      {
         // no testscreen defines use default
         testscreenList.push_back(1);
         DIA_TR_INF("--- dia_RoutineCtrlDisplayTestScreenSlideshow::start => Use Testscreen:%d",testscreenList[0]);
         testscreenList.push_back(2);
         DIA_TR_INF("--- dia_RoutineCtrlDisplayTestScreenSlideshow::start => Use Testscreen:%d",testscreenList[1]);
         testscreenList.push_back(3);
         DIA_TR_INF("--- dia_RoutineCtrlDisplayTestScreenSlideshow::start => Use Testscreen:%d",testscreenList[2]);
      }
      else
      {
         // we get a number of testcreens
         if(size== 5)
         {
            // one is to less
         }
         else
         {
            for (tU32 i=4; i<size; i++)
            {
               // fill list
               testscreenList.push_back(params[i]);
               DIA_TR_INF("--- dia_RoutineCtrlDisplayTestScreenSlideshow::start => Use Testscreen:%d",params[i]);
            }
         }
      }

      if(testscreenList.size() != 0)
      {
         // set running flag
         isRunning = true;
         numberOfTestScreens = 0;

         // connect to listener
         dia_IHmi* pIHmi = OSAL_NULL;;
         if ((querySysAdapterInterface<dia_IHmi>(&pIHmi) == DIA_SUCCESS) && pIHmi)
         {
            (tVoid) setSysAdapterListener<dia_IHmiListener>(this);
            retCode = sendTestscreen(testscreenList[0]);
            if(retCode == DIA_SUCCESS)
            {
               statusResponse = ROUTINE_RUNNING;
            }
         }
         else
         {
            DIA_TR_INF("!!! dia_RoutineCtrlDisplayTestScreenSlideshow::start => ERROR: pIHmi == NULL");
            retCode = DIA_E_CONDITIONS_NOT_CORRECT;
         }

         if (retCode != DIA_SUCCESS)
         {
            // start failed, return to not running
            (tVoid) unsetSysAdapterListener<dia_IHmiListener>(this);
            isRunning = false;
         }
      }
      else
      {
         retCode = DIA_E_OUT_OF_RANGE;
      }
   }

   mResults.push_back(statusResponse);
   mIsResultReady = TRUE;

   return retCode;
#endif

   return DIA_E_NOT_IMPLEMENTED;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlDisplayTestScreenSlideshow::stop ( std::vector<tU8>& /*params*/)
{
#if 0 // gib2hi: disabled as dia_IHMI/dia_IHMIListener are project specific interfaces

   dia_tclFnctTrace oTrace("dia_RoutineCtrlDisplayTestScreenSlideshow::stop");
   tDiaResult  retCode         = DIA_SUCCESS;


   (tVoid) unsetSysAdapterListener<dia_IHmiListener>(this);
   statusResponse  = ROUTINE_STOPPED;
   isRunning = false;

   // ***********************************
   // generate response
   // ***********************************
   mResults.push_back(statusResponse);
   mIsResultReady = TRUE;
   return retCode;
#endif

   return DIA_E_NOT_IMPLEMENTED;
}


//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlDisplayTestScreenSlideshow::requestResult ( std::vector<tU8>& results )
{
   tDiaResult retCode         = DIA_E_SEQUENCE_ERROR;

   results.clear();
   if ( !(mResults.empty()) )
   {
      DIA_TR_INF("dia_RoutineCtrlDisplayTestScreenSlideshow::requestResult --- 1");
      std::vector<tU8>::iterator iter = mResults.begin();
      for ( ; iter != mResults.end(); iter++ )
      {
         results.push_back(*iter);
      }
      mResults.clear();
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("dia_RoutineCtrlDisplayTestScreenSlideshow::requestResult => (%d) NumberOfTestScreens:%d", mStatus,numberOfTestScreens);
      results.push_back(statusResponse);
      results.push_back((tU8)(numberOfTestScreens>>24));
      results.push_back((tU8)(numberOfTestScreens>>16));
      results.push_back((tU8)(numberOfTestScreens>>8));
      results.push_back((tU8)(numberOfTestScreens));
      mIsResultReady = TRUE;
      retCode = DIA_SUCCESS;
   }

   return retCode;
}


//------------------------------------------------------------------------------

#if 0 // gib2hi: disabled as dia_IHMI/dia_IHMIListener are project specific interfaces

tVoid
dia_RoutineCtrlDisplayTestScreenSlideshow::vOnIoCtrlTestscreenResult(const tenIoControlAction enAction, const tU8 enTestscreenId)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlDisplayTestScreenSlideshow::vOnIoCtrlTestscreenResult");
   tDiaResult  retCode         = DIA_SUCCESS;

   DIA_TR_INF( "--- dia_RoutineCtrlDisplayTestScreenSlideshow::vOnIoCtrlTestscreenResult => Action:%d Id:%d",enAction, enTestscreenId);
   if(isRunning)
   {
      // wait the delay before send next testscreen
      OSAL_s32ThreadWait(delay);

      // switch to next testscreen
      currentTestscreen++;

      if(currentTestscreen >= testscreenList.size())
      {
         // max reached set to first testscreen
         currentTestscreen = 0;
      }

      retCode = sendTestscreen(testscreenList[currentTestscreen]);
      if(retCode != DIA_SUCCESS)
      {
         // send not possible
         DIA_TR_ERR( "!!! dia_RoutineCtrlDisplayTestScreenSlideshow::vOnIoCtrlTestscreenResult => Send FAILED Screen:%d Error:%x",currentTestscreen, retCode);
         statusResponse = ROUTINE_ABORTED;
      }
      else
      {
         numberOfTestScreens++;
      }
   }//if(isRunning)
}
//------------------------------------------------------------------------------

tVoid
dia_RoutineCtrlDisplayTestScreenSlideshow::vOnIoCtrlTestscreenError ( const tU32 errCode )
{
   DIA_TR_ERR("!!! dia_RoutineCtrlDisplayTestScreenSlideshow::vOnIoCtrlTestscreenError => ERROR:%x",errCode);
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlDisplayTestScreenSlideshow::sendTestscreen ( tU8 testscreen ) const
{
   tDiaResult  retCode         = DIA_SUCCESS;
   DIA_TR_INF("--- dia_RoutineCtrlDisplayTestScreenSlideshow::sendTestscreen => Set Testscreen to %d",testscreen);

   dia_IHmi* pIHmi = OSAL_NULL;;
   if ((querySysAdapterInterface<dia_IHmi>(&pIHmi) == DIA_SUCCESS) && pIHmi)
   {
      if ( pIHmi->vControlTestscreen(EN_ACTION_SET,testscreen) != DIA_SUCCESS)
      {
         retCode = DIA_E_CONDITIONS_NOT_CORRECT;
         DIA_TR_ERR("!!! dia_RoutineCtrlDisplayTestScreenSlideshow::sendTestscreen => ERROR: vControlTestscreen != DIA_SUCCESS");
      }
      else
      {
         DIA_TR_INF("--- dia_RoutineCtrlDisplayTestScreenSlideshow::sendTestscreen => Send Successfully to Server");
      }
   }
   else
   {
      NORMAL_M_ASSERT_ALWAYS();
      retCode = DIA_E_CONDITIONS_NOT_CORRECT;
   }
   return retCode;
}

#endif
