/*
 * dia_InOutThreadParam.h
 *
 *  Created on: 05.03.2015
 *      Author: kaa1hi
 */

#ifndef DIA_INOUTTHREADPARAM_H_
#define DIA_INOUTTHREADPARAM_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"    //needed by class dia_RoutineCtrlChecksum
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include "common/framework/application/dia_Lock.h"
#endif

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#include <common/framework/application/dia_ActiveObject.h>
#endif

#ifndef DIA_ROUTINECTRLCHECKSUM_H_
#include "common/services/uds/production/dia_RoutineCtrlChecksum.h"
#endif



#define DIA_C_U32_ROUTINECTRL_DEF_THREAD_PRIO      ((tU32)  0x5f)
#define DIA_C_U32_ROUTINECTRL_DEF_STACK_SIZE       ((tU32) 10000)

#define COOKIE_STR_LEN                             ((tU8)20)


enum dia_eCAV_Mem_Area
{
   DIA_EN_CAV_MEM_AREA_UNKNOWN = 0,
   DIA_EN_CAV_MEM_AREA_RAW_NOR,           /* 1 */   /* routineID=0x3060 */
   DIA_EN_CAV_MEM_AREA_RAW_EMMC_USER,     /* 2 */   /* routineID=0x3062 */
   DIA_EN_CAV_MEM_AREA_RAW_BOOT,          /* 3 */   /* routineID=0x3064 */
   DIA_EN_CAV_MEM_AREA_FFS_ROOT,          /* 4 */   /* routineID=0x3063 */
   DIA_EN_CAV_MEM_AREA_FFS_STATIC,        /* 5 */   /* routineID=0x3067 */
   DIA_EN_CAV_MEM_AREA_FFS_MAP_DATA,      /* 6 */   /* routineID=0x3068 */
   DIA_EN_CAV_MEM_AREA_FFS_SDB,           /* 7 */   /* routineID=0x306B */
   DIA_EN_CAV_MEM_AREA_FFS_GRACENOTE,     /* 8 */   /* routineID=0x306C */
   DIA_EN_CAV_MEM_AREA_V850_BOOTLOADER,   /* 9 */   /* routineID=0x3065 */
   DIA_EN_CAV_MEM_AREA_V850_APPLICATION,  /* 10*/   /* routineID=0x3066 */
   DIA_EN_CAV_MEM_AREA_NAV,               /* 11*/   /* routineID=0x3068 */    /*deprecated, info from SwUpdate team: please do not use this, use DIA_EN_CAV_MEM_AREA_FFS_MAP_DATA instead*/
   DIA_EN_CAV_MEM_AREA_COUNT
};


class dia_InOutThreadParam
   : public dia_ActiveObject
{
public:
   dia_InOutThreadParam(tCString name,
         tU32 priority  = DIA_C_U32_ROUTINECTRL_DEF_THREAD_PRIO,
         tU32 stackSize = DIA_C_U32_ROUTINECTRL_DEF_STACK_SIZE):
      dia_ActiveObject(name,priority,stackSize),
      mReqDiagArea(DIA_EN_CAV_MEM_AREA_UNKNOWN),
                                       mScriptExitCode(DIA_FAILED/*DIA_SCRIPT_RET_VAL_NOK*/),
                                       mbThreadStarted(false)
   {
      mCookieString[0] = 0;
   }

   virtual ~dia_InOutThreadParam() {}

   //! type of requested area
   dia_eCAV_Mem_Area mReqDiagArea;

   //! exit code of script (possible values: 0 <OK>, 1, 2)
   tU8 mScriptExitCode;

   //! true if thread has been started and not finished yet, otherwise false
   bool mbThreadStarted;

   //! cookie string
   char mCookieString[COOKIE_STR_LEN];

   //! @brief Entry point for thread
   //! @param[in,out] pvArg pointer to instances of input&output parameters.
   virtual void vThreadEntrypointObject(void);
};

#endif /* DIA_INOUTTHREADPARAM_H_ */
