/*
 * dia_InOutThreadParam.cpp
 *
 *  Created on: 05.03.2015
 *      Author: kaa1hi
 */

#ifndef DIA_ROUTINECTRLCHECKSUM_H_
#include "dia_RoutineCtrlChecksum.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#include <errno.h>
#include <ctime>        //needed for time()

#define DIA_INOUTTHREAD_MAX_BUFF_LEN_FOR_LINE          256
#define DIA_INOUTTHREAD_MAX_BUFF_LEN_FOR_COMMAND       512
#define DIA_INOUTTHREAD_ERROR_CODE_OF_PCLOSE          ((int)-1)
#define DIA_CHECKSUM_SCRIPT_RETURN_VALUE_KEY  "script_return_value="


void
dia_InOutThreadParam::vThreadEntrypointObject(void)
{
   DIA_TR_INF("## NEW THREAD ## ENTER dia_InOutThreadParam::vThreadEntrypointObject");

//   if (NULL==pvArg)
//   {
//      DIA_TR_INF("## NEW THREAD ## dia_RoutineCtrlChecksum::vThreadEntry pvArg is NULL. Exit this thread.");
//
//      // Now everything cleared up --- Exit this thread of execution
//      OSAL_vThreadExit();
//      return;
//   }

   char cmd[DIA_INOUTTHREAD_MAX_BUFF_LEN_FOR_COMMAND] = {0};
   FILE *ptr = NULL;
   int retValScript = DIA_FAILED; //DIA_SCRIPT_RET_VAL_NOK;
   dia_InOutThreadParam* pInOutThreadParam = /*static_cast<dia_InOutThreadParam*>*/(this);
   int cx = 0;

   switch (pInOutThreadParam->mReqDiagArea)
   {
      case DIA_EN_CAV_MEM_AREA_FFS_ROOT:
      case DIA_EN_CAV_MEM_AREA_FFS_STATIC:
      case DIA_EN_CAV_MEM_AREA_FFS_MAP_DATA:
      case DIA_EN_CAV_MEM_AREA_FFS_SDB:
      case DIA_EN_CAV_MEM_AREA_FFS_GRACENOTE:
         cx = snprintf ( cmd, sizeof(cmd),
#ifndef __DIA_UNIT_TESTING__
                                 "/bin/ash "
#endif
                                 "%s"
#ifndef __DIA_UNIT_TESTING__
                                 " -m %s -a %s -p %s -c %s"
#endif
                                 "; echo \"%s$?\"",
                                 dia_RoutineCtrlChecksum::sFullPathScript,
#ifndef __DIA_UNIT_TESTING__
                                 aDiaChkSumMapTable[pInOutThreadParam->mReqDiagArea].ModuleName,
                                 aDiaChkSumMapTable[pInOutThreadParam->mReqDiagArea].AreaName,
                                 aDiaChkSumMapTable[pInOutThreadParam->mReqDiagArea].AreaName,
                                 pInOutThreadParam->mCookieString,
#endif
                                 DIA_CHECKSUM_SCRIPT_RETURN_VALUE_KEY );
         DIA_TR_INF("DIA_EN_CAV_MEM_AREA_FFS_ROOT or DIA_EN_CAV_MEM_AREA_FFS_STATIC");
      break;

      case DIA_EN_CAV_MEM_AREA_RAW_NOR:
      case DIA_EN_CAV_MEM_AREA_RAW_EMMC_USER:
      case DIA_EN_CAV_MEM_AREA_RAW_BOOT:
      case DIA_EN_CAV_MEM_AREA_V850_BOOTLOADER:
      case DIA_EN_CAV_MEM_AREA_V850_APPLICATION:
         cx = snprintf ( cmd, sizeof(cmd),
#ifndef __DIA_UNIT_TESTING__
                        "/bin/ash "
#endif
                        "%s"
#ifndef __DIA_UNIT_TESTING__
                        " -m %s -a %s -c %s"
#endif
                        "; echo \"%s$?\"",
                        dia_RoutineCtrlChecksum::sFullPathScript,
#ifndef __DIA_UNIT_TESTING__
                        aDiaChkSumMapTable[pInOutThreadParam->mReqDiagArea].ModuleName,
                        aDiaChkSumMapTable[pInOutThreadParam->mReqDiagArea].AreaName,
                        pInOutThreadParam->mCookieString,
#endif
                        DIA_CHECKSUM_SCRIPT_RETURN_VALUE_KEY );
         break;
      case DIA_EN_CAV_MEM_AREA_NAV:
              cx = snprintf ( cmd, sizeof(cmd),
     #ifndef __DIA_UNIT_TESTING__
                             "/bin/ash "
     #endif
                             "%s"
     #ifndef __DIA_UNIT_TESTING__
                             " -p %s -c %s"
     #endif
                             "; echo \"%s$?\"",
                             dia_RoutineCtrlChecksum::sFullPathScript,
     #ifndef __DIA_UNIT_TESTING__
                             aDiaChkSumMapTable[pInOutThreadParam->mReqDiagArea].AreaName,
                             pInOutThreadParam->mCookieString,
     #endif
                             DIA_CHECKSUM_SCRIPT_RETURN_VALUE_KEY );
              break;
      default:
         DIA_TR_INF("## NEW THREAD ## dia_RoutineCtrlChecksum::vThreadEntry ERROR - unknown requested area");
         break;
   }

   if (cx<0)
   {
      DIA_TR_INF("## NEW THREAD ## ERROR: snprintf failed cx=0x%08X. Command buffer is too small.", cx);
      DIA_TR_INF("## NEW THREAD ## ERROR: Length of cmd is %zu.", sizeof(cmd));
   }
   else if (0==cx)
   {
      DIA_TR_INF("## NEW THREAD ## ERROR: Wrong requested area.");
   }
   else if (cx<(int)sizeof(cmd))
   {
      DIA_TR_INF( "## NEW THREAD ## cmd = %s", cmd);

      if ((ptr = popen(cmd, "r")) != NULL)
      {
         DIA_TR_INF("## NEW THREAD ## popen successful");

         int i = 0;
         char buff[DIA_INOUTTHREAD_MAX_BUFF_LEN_FOR_LINE] = {0};
         while (fgets(buff, DIA_INOUTTHREAD_MAX_BUFF_LEN_FOR_LINE, ptr) != NULL)
         {
            /* remove trailing white space from string */
            size_t len = strlen(buff);
            if (len>0 && len<sizeof(buff))
            {
               char* pToTerminated = buff +  len -1;

               while (0!=isspace(pToTerminated[0]) && (len>0))
               {
                  //DIA_TR_INF("Removed one letter: 0x%02X", pToTerminated[0]);
                  pToTerminated[0] = 0;
                  pToTerminated--;
                  len--;
               }
            }
            else
            {
               DIA_TR_INF("## NEW THREAD ## ERROR: len=%zu is not less than %zu", len, sizeof(buff));
               DIA_TR_INF("## NEW THREAD ## buff=%s", buff);
            }

            /* skip empty strings */
            if (len>0)
            {
               DIA_TR_INF("## NEW THREAD ## #Line[%02d]%s", i, buff);

               /* get return value from executed script */
               char* p = strstr( buff, DIA_CHECKSUM_SCRIPT_RETURN_VALUE_KEY);
               if (NULL!=p)
               {
                  p += (sizeof(DIA_CHECKSUM_SCRIPT_RETURN_VALUE_KEY) - 1);

                  DIA_TR_INF("## NEW THREAD ## %s", p);

                  retValScript = 0;
                  while (((p-buff)<DIA_INOUTTHREAD_MAX_BUFF_LEN_FOR_LINE) && isdigit(p[0]))
                  {
                     retValScript = (retValScript*10) + (int)(p[0] - '0');
                     p++;
                  }
               }
            }
            i++;
         }

         int pCloseReturnValue = pclose(ptr);

         DIA_TR_INF("## NEW THREAD ## pCloseReturnValue = 0x%08X", pCloseReturnValue);

         if (DIA_INOUTTHREAD_ERROR_CODE_OF_PCLOSE==pCloseReturnValue)
         {
            DIA_TR_INF( "## NEW THREAD ## ERROR: pclose return -1 with errno = 0x%08X", errno);
         }
      }
      else
      {
         DIA_TR_INF( "## NEW THREAD ## ERROR: popen return NULL");
      }
   }
   else
   {
      DIA_TR_INF("## NEW THREAD ## ERROR: Other error cx=%d sizeof(cmd)=%zu", cx, sizeof(cmd));
   }

   pInOutThreadParam->mScriptExitCode = static_cast<tU8>(retValScript);
   DIA_TR_INF("## NEW THREAD ## RETURN dia_RoutineCtrlChecksum::vThreadEntry  retVal=0x%08X", retValScript );

   pInOutThreadParam->mbThreadStarted = false;  //writing is protected by semaphore


   DIA_TR_INF("############################################################");
   DIA_TR_INF("#");
   DIA_TR_INF("# %s THREAD IS GETTING TERMINATED !!!!!!!!!!!!!!!!!!!!!!!!!", mThreadName);
   DIA_TR_INF("#");
   DIA_TR_INF("############################################################");


#ifndef VARIANT_S_FTR_ENABLE_THREAD_AS_PTHREAD_THREAD
   // Now everything cleared up --- Exit this thread of execution
   OSAL_vThreadExit();
#endif
}
