/*
 * dia_IOCtrl_PlayedTrack.cpp
 *
 *  Created on: 08.08.2012
 *      Author: shw2abt
 */
//TTFis:> DIA_REQ UDS 07 2F 61 21 03 00 xx
//                                  (00 xx) -> track number

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#include "common/services/uds/production/dia_IOCtrl_PlayedTrack.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
//#define DATA_LENGTH 2

//------------------------------------------------------------------------------

dia_IOCtrl_PlayedTrack::dia_IOCtrl_PlayedTrack ( tVoid )
   : dia_IOCtrlSignalRestrictedToRemoteControl (
         DIA_C_U16_DID_RBCM_CDDA_PLAYED_TRACK,
         DIA_EN_IOCTRL_SIGTYPE_PLAYED_TRACK,
         2 // Payload lenght
         //DIA_EN_IOCTRL_CTRLMODE_ECU
         // 4. legt Zeitueberwachung fest - Monitoring Mode
     )
{
}

//------------------------------------------------------------------------------

dia_IOCtrl_PlayedTrack::~dia_IOCtrl_PlayedTrack ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IMediaAudioCdListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrl_PlayedTrack::~dia_IOCtrl_PlayedTrack !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrl_PlayedTrack::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrl_PlayedTrack::handleRequest(tU8,vector<tU8>*)");

   tBool errorDetected = TRUE;

   DIA_TR_INF("dia_IOCtrl_PlayedTrack::handleRequest: start Handling.");
   dia_IMediaAudioCd* pInterface = 0;
   if ( querySysAdapterInterface<dia_IMediaAudioCd>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         tU8 high_byte = (tU8) ctrlValue->at(0);
         tU8 low_byte  = (tU8) ctrlValue->at(1);
         const tU16 trackNumber = U8_2_U16(high_byte,low_byte);

         (tVoid) setSysAdapterListener<dia_IMediaAudioCdListener>(this);
         if ( pInterface->selectAudioTrack(trackNumber) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      } else {
         DIA_TR_INF("pInterface failed");
      }

   } else {
      DIA_TR_INF("querySysAdapterInterface<dia_IMediaAudioCd>(&pInterface) failed");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IMediaAudioCdListener>(this);
      DIA_TR_ERR("dia_IOCtrl_PlayedTrack ---  SEND TO MEDIAAUDIOCD SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrl_PlayedTrack::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrl_PlayedTrack::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_IMediaAudioCd* pInterface = 0;
      if ( querySysAdapterInterface<dia_IMediaAudioCd>(&pInterface) == DIA_SUCCESS )
      {
         if ( pInterface )
         {
            (tVoid) setSysAdapterListener<dia_IMediaAudioCdListener>(this);
            if ( pInterface->selectAudioTrack(0) != DIA_SUCCESS )
            {
               DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SELECTAUDIOTRACK !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrl_PlayedTrack::vOnTrackChangeResult ( tDiaResult success ){
   dia_tclFnctTrace trc("dia_IOCtrl_PlayedTrack::vOnTrackChangeResult");
   
   (tVoid) unsetSysAdapterListener<dia_IMediaAudioCdListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrl_PlayedTrack::vOnTrackChangeResult SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrl_PlayedTrack::vOnTrackChangeResult DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrl_PlayedTrack::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrl_PlayedTrack::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IMediaAudioCdListener>(this);
}

