/*
 * dia_IOCtrl_KeyIlluminationPWM.h
 *
 *  Created on: 24.03.2014
 *      Author: rva5cob
 */
// TTFis:\> DIA_REQ UDS 04 2F 62 11 03/02/00

#ifndef __INCLUDED_DIA_IOCTRL_KEY_ILLUMINATION_PWM__
#define __INCLUDED_DIA_IOCTRL_KEY_ILLUMINATION_PWM__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_LISTENER__
#include "common/interfaces/dia_IDimmingListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrl_KeyIlluminationPWM
	: public dia_IOCtrlSignal,
	  public dia_IDimmingListenerImpl
{
public:
   //! class constructor
   dia_IOCtrl_KeyIlluminationPWM ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrl_KeyIlluminationPWM ( tVoid );

   //! handle freeze request
   virtual tDiaResult handleFreeze ( tVoid );
   //! short term adjustment for key illumination
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //! the timer of the associated service handler has been elapsed
   virtual tVoid handleTimeout ( tVoid );

   //! Signal to inform requester about success of the key illumination pwm change request
   virtual tVoid vOnKeyPWMChangeResult ( tU16 pwm );

   virtual tVoid vOnEmulationModeStatus (tU8 u8mode);

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! Set the emulation mode based on the control state in action
   tDiaResult vSetEmulationMode ( dia_eDimEmulationMode mode );

};

#endif /* __INCLUDED_DIA_IOCTRL_KEY_ILLUMINATION__ */
