/*
 * dia_IOCtrl_KeyIllumination.h
 *
 *  Created on: 31.08.2012
 *      Author: bhs1hi
 */
// TTFis:\> DIA_REQ UDS 04 2F 62 10 03/02/00

#ifndef __INCLUDED_DIA_IOCTRL_KEY_ILLUMINATION__
#define __INCLUDED_DIA_IOCTRL_KEY_ILLUMINATION__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_LISTENER__
#include "common/interfaces/dia_IDimmingListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrl_KeyIllumination
	: public dia_IOCtrlSignal,
	  public dia_IDimmingListenerImpl
{
public:
   //! class constructor
   dia_IOCtrl_KeyIllumination ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrl_KeyIllumination ( tVoid );

   //! handle freeze request
   virtual tDiaResult handleFreeze ( tVoid );
   //! short term adjustment for key illumination
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //! the timer of the associated service handler has been elapsed
   virtual tVoid handleTimeout ( tVoid );

   //! Signal to inform requester about success of the key illumination brightness change request
   virtual tVoid vOnKeyBrightnessChangeResult ( tU16 brightness );

   virtual tVoid vOnEmulationModeStatus (tU8 u8mode);

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! Set the emulation mode based on the control state in action
   tDiaResult vSetEmulationMode ( dia_eDimEmulationMode mode );

};

#endif /* __INCLUDED_DIA_IOCTRL_KEY_ILLUMINATION__ */
