/*
 * dia_IOCtrl_KeyIllumination.cpp
 *
 *  Created on: 31.08.2012
 *      Author: bhs1hi
 *
 * TTFis:\> DIA_REQ UDS 04 2F 62 10 03/02/00
 *
 * -----------------------------------------------------------------------------------
 * Date 			| Author			 | Modification                               |
 * 01.12.15    		| sbr5kor	  		 | AIVI-12208 & CMG3G-8222                    |
 * ------------------------------------------------------------------------------------
 */

#if 0
#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrl_KeyIllumination.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//------------------------------------------------------------------------------

dia_IOCtrl_KeyIllumination::dia_IOCtrl_KeyIllumination ( tVoid )
   : dia_IOCtrlSignal (
         DIA_C_U16_DID_RBCM_KEY_ILLUMINATION,
         DIA_EN_IOCTRL_SIGTYPE_KEYILLUMINATION_BRIGHTNESS,
         2,
         DIA_EN_IOCTRL_CTRLMODE_TESTER
     )
{
}

//------------------------------------------------------------------------------

dia_IOCtrl_KeyIllumination::~dia_IOCtrl_KeyIllumination ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrl_KeyIllumination::~dia_IOCtrl_KeyIllumination !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrl_KeyIllumination::handleFreeze ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_IOCtrl_KeyIllumination::handleFreeze()");

   tDiaResult retCode = vSetEmulationMode(DIA_EN_DIM_EMULATION_MODE_KEYBFREEZE);

   if ( retCode == DIA_SUCCESS )
   {
      mIsResultReady = FALSE;
   }
   else
   {
      DIA_TR_INF("FAILED TO FREEZE KEY ILLUMINATION BRIGHTNESS !!!");
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrl_KeyIllumination::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrl_KeyIllumination::handleRequest(tU8,vector<tU8>*)");

   tBool errorDetected = TRUE;

   DIA_TR_INF("dia_IOCtrl_KeyIllumination::handleRequest: start Handling.");
   dia_IDimming* pInterface = 0;
   if ( querySysAdapterInterface<dia_IDimming>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         tU8 high_byte = (tU8) ctrlValue->at(0);
         tU8 low_byte  = (tU8) ctrlValue->at(1);
         const tU16 brightness = U8_2_U16(high_byte,low_byte);

         (tVoid) setSysAdapterListener<dia_IDimmingListener>(this);
         if ( pInterface->dia_setKeyIlluminationBrightness(brightness) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      } else {
         DIA_TR_INF("pInterface failed");
      }

   } else {
      DIA_TR_INF("querySysAdapterInterface<dia_IDimming>(&pInterface) failed");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
      DIA_TR_ERR(" ---  SEND TO DIMMING SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrl_KeyIllumination::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrl_KeyIllumination::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      retCode = vSetEmulationMode(DIA_EN_DIM_EMULATION_MODE_OFF);

      if ( retCode != DIA_SUCCESS )
      {
         DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SET : KEYILLUMINATIONBRIGHTNESS !!!");
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrl_KeyIllumination::vOnKeyBrightnessChangeResult ( tU16 /*brightness*/ )
{
   dia_tclFnctTrace trc("dia_IOCtrl_KeyIllumination::vOnKeyBrightnessChangeResult");

   DIA_TR_INF("dia_IOCtrl_KeyIllumination::vOnKeyBrightnessChangeResult: Handle Result Message.");

   (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrl_KeyIllumination::vOnEmulationModeStatus ( tU8 mode )
{
   dia_tclFnctTrace trc("dia_IOCtrl_KeyIllumination::vOnEmulationModeStatus");

   (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);

   switch ( mode )
   {
   case DIA_EN_DIM_EMULATION_MODE_KEYBFREEZE:
      (tVoid) dia_IOCtrlSignal::handleFreeze();
      break;

   default:
      break;
   }

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrl_KeyIllumination::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrl_KeyIllumination::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrl_KeyIllumination::vSetEmulationMode ( dia_eDimEmulationMode mode )
{
   dia_tclFnctTrace oTrace("dia_IOCtrl_KeyIllumination::vSetEmulationMode()");

   tDiaResult retCode = DIA_E_NOERROR;

   dia_IDimming* pInterface = 0;
   if ( (querySysAdapterInterface<dia_IDimming>(&pInterface) == DIA_SUCCESS) && pInterface )
   {
      (tVoid) setSysAdapterListener<dia_IDimmingListener>(this);
      retCode = pInterface->setEmulationMode(mode);
      if ( retCode != DIA_SUCCESS )
      {
         DIA_TR_INF("FAILED TO SET THE EMULATION MODE: KEYILLUMINATIONBRIGHTNESS !!!");
      }
   }

   return retCode;
}

