/*
 * dia_IOCtrlVideoSourceSet.h
 *
 *  Created on: 15.04.2014
 *      Author: rva5cob
 */


#ifndef __INCLUDED_DIA_IOCTRL_VIDEO_SOURCE_SET__
#define __INCLUDED_DIA_IOCTRL_VIDEO_SOURCE_SET__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include <common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VIDEOSOURCECONTROL_LISTENER__
#include <common/interfaces/dia_IVideoSourceControlListener.h>
#endif

#define DIA_C_U8_REQUEST_VIDEO_SOURCE_INVALID   ((tU8) 0x00)
#define DIA_C_U8_REQUEST_VIDEO_SOURCE_HMI       ((tU8) 0x01)
#define DIA_C_U8_REQUEST_VIDEO_SOURCE_RVC       ((tU8) 0x02)
#define DIA_C_U8_REQUEST_VIDEO_SOURCE_DVD       ((tU8) 0x03)

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlVideoSourceSet
   : public dia_IOCtrlSignal, //RestrictedToRemoteControl,
     public dia_IVideoSourceControlListener

{
public:
   //! class constructor
   dia_IOCtrlVideoSourceSet ( void );
   //! class destructor
   virtual ~dia_IOCtrlVideoSourceSet ( void );

   //! incoming tester request. ctrlValue holds the ID of the video source to be activated
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual void handleTimeout ( void );

   tU8 getRequestedVideoSource ( void ) const { return mRequestedVideoSource; }

   //! update on an successful video source switch
   virtual void vOnVideoSourceUpdate ( dia_eVideoSourceID newSrcID, dia_eVideoSourceID prevSrcID );
   //! feedback that the requested video source switch operation has been failed
   virtual void vOnVideoSourceError ( tDiaResult errCode );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

protected:
   //! requested video source
   tU8 mRequestedVideoSource;
};

#endif /* __INCLUDED_DIA_IOCTRL_VIDEO_SOURCE_SET__ */
