/*
* dia_IOCtrlVideoSourceSet.cpp
*
*  Created on: 04.11.2014
*      Author: rva5cob
*/

#include <common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h>

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_IOCtrlVideoSourceSet.h"

//------------------------------------------------------------------------------

//
//typedef enum
//{
//
//   VID_M_ACTIVE_MEDIA = 0,
//   VID_M_ACTIVE_DVD,
//   VID_M_ACTIVE_RVCONPOPUP,
//   VID_M_ACTIVE_RVCONHMI,
//   VID_M_ACTIVE_SPI,
//   VID_M_ACTIVE_NAVI,
//   VID_M_ACTIVE_NORMAL_HMI,
//   VID_M_ACTIVE_UNKNOWN,
//   VID_M_VID_SRC_DISCONNECTED,
//   VID_M_DVD_CONNECTED,
//   DVD_P_STREAMING_STARTED
//
//} dia_tcompResponseState;
//


dia_IOCtrlVideoSourceSet::dia_IOCtrlVideoSourceSet ( void )
   : dia_IOCtrlSignal ( DIA_C_U16_DID_RBCM_VIDEO_SOURCE_ACTIVE, DIA_EN_IOCTRL_SIGTYPE_VIDEO_SOURCE ),
     mRequestedVideoSource(DIA_C_U8_REQUEST_VIDEO_SOURCE_INVALID)
{
//
//   mVidDestId     = DIA_EN_VIDEO_DEST_UNKNOWN;
//   mVidDestType   = DIA_EN_VIDEO_FRONT_DISPLAY;
//
//   mVidDestIdPrev = DIA_EN_VIDEO_DEST_MEDIA; /*TO BE REVISITED: rva5cob*/
}

//------------------------------------------------------------------------------

dia_IOCtrlVideoSourceSet::~dia_IOCtrlVideoSourceSet ( void )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IVideoSourceControlListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlVideoSourceSet::~dia_IOCtrlVideoSourceSet !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlVideoSourceSet::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlVideoSourceSet::handleRequest()");

   tDiaResult retCode  = DIA_SUCCESS;
   tBool errorDetected = TRUE;

   mIsResultReady = FALSE;
   mRequestedVideoSource = DIA_C_U8_REQUEST_VIDEO_SOURCE_INVALID;

   if ( ctrlValue && ctrlValue->size() )
   {
      DIA_TR_INF(" ---  VIDEO SOURCE CONTROL --- 0 !!!!");
      dia_IVideoSourceControl* pInterface = 0;
      if ( (querySysAdapterInterface<dia_IVideoSourceControl>(&pInterface) == DIA_SUCCESS) && pInterface )
      {
         DIA_TR_INF(" ---  VIDEO SOURCE CONTROL --- 1 !!!!");
         (tVoid) setSysAdapterListener<dia_IVideoSourceControlListener>(this);

         dia_eVideoSourceID videoSrcID = DIA_EN_VIDEO_SOURCE_ID_UNKNOWN;
         mRequestedVideoSource = (*ctrlValue)[0];

         switch ( mRequestedVideoSource )
         {
         case DIA_C_U8_REQUEST_VIDEO_SOURCE_HMI:
            videoSrcID = DIA_EN_VIDEO_SOURCE_ID_HMI;
            break;
         case DIA_C_U8_REQUEST_VIDEO_SOURCE_RVC:
            videoSrcID = DIA_EN_VIDEO_SOURCE_ID_RVC;
            break;
         case DIA_C_U8_REQUEST_VIDEO_SOURCE_DVD:
            videoSrcID = DIA_EN_VIDEO_SOURCE_ID_DVD;
            break;
         default:
            break;
         }

         DIA_TR_INF(" ---  VIDEO SOURCE CONTROL --- 2 !!!! (testerSrcID=0x%02x, internSrcID==0x%02x)", mRequestedVideoSource, videoSrcID);

         retCode = pInterface->activateVideoSource(videoSrcID);
         if ( retCode == DIA_SUCCESS )
         {
            DIA_TR_INF(" ---  VIDEO SOURCE CONTROL --- 3 !!!! pInterface->activateVideoSource() == DIA_SUCCESS");
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF(" ---  VIDEO SOURCE CONTROL --- 3 !!!!");
         }
      }
      else
      {
         retCode = DIA_E_CONDITIONS_NOT_CORRECT;
      }
   }
   else
   {
      retCode = DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
   }

   DIA_TR_INF(" ---  VIDEO SOURCE CONTROL --- 3 !!!!");

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IVideoSourceControlListener>(this);
      switch ( retCode )
      {
      case DIA_E_INVALID_SOURCE:
         retCode = DIA_E_OUT_OF_RANGE;
         break;
      case DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT:
      case DIA_E_CONDITIONS_NOT_CORRECT:
         break;
      default:
         retCode = DIA_E_CONDITIONS_NOT_CORRECT;
         break;
      }
      DIA_TR_INF(" ---  SEND TO VIDEO SOURCE CONTROL FAILED!!!!");
      return retCode;
   }

   if ( mIsResultReady )
   {
      (tVoid) unsetSysAdapterListener<dia_IVideoSourceControlListener>(this);
      DIA_TR_INF(" ---  SETTING VIDEO SOURCE CONTROL SUCCEEDED !!!!");
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlVideoSourceSet::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlVideoSourceSet::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
        // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_IVideoSourceControl* pInterface = 0;
      if ( (querySysAdapterInterface<dia_IVideoSourceControl>(&pInterface) == DIA_SUCCESS) && pInterface )
      {
         (tVoid) setSysAdapterListener<dia_IVideoSourceControlListener>(this);
         if ( pInterface->activateVideoSource(DIA_EN_VIDEO_SOURCE_ID_HMI) != DIA_SUCCESS )
         {
            DIA_TR_INF("FAILED TO RESET VIDEO SOURCE TO HMI (DEFAULT) !!!");
            retCode = DIA_FAILED;
         }
      }
      else
      {
         retCode = DIA_E_INVALID_POINTER;
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

////------------------------------------------------------------------------------
//
//tDiaResult
//   dia_IOCtrlVideoSourceSet::vOnTerminate ( dia_eIOCtrlStatus status )
//{
//   dia_tclFnctTrace oTrace("dia_IOCtrlVideoSourceSet::vOnTerminate()");
//#if 0
//   // this ioctrl is no longer active
//   eSetStatus(status);
//#endif
//   return DIA_SUCCESS;
//}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlVideoSourceSet::vOnVideoSourceUpdate ( dia_eVideoSourceID /*newSrcID*/, dia_eVideoSourceID /*prevSrcID*/ )
{
   dia_tclFnctTrace trc("dia_IOCtrlVideoSourceSet::vOnVideoSourceUpdate");

   (tVoid) unsetSysAdapterListener<dia_IVideoSourceControlListener>(this);
   mIsResultReady = TRUE;

#ifndef __DIA_UNIT_TESTING__
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
#endif
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlVideoSourceSet::vOnVideoSourceError ( tDiaResult /*errCode*/ )
{
   dia_tclFnctTrace trc("dia_IOCtrlVideoSourceSet::vOnVideoSourceError");


   (tVoid) unsetSysAdapterListener<dia_IVideoSourceControlListener>(this);
   mIsResultReady = TRUE;

#ifndef __DIA_UNIT_TESTING__
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
#endif
}

void
dia_IOCtrlVideoSourceSet::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlVideoSourceSet::handleTimeout");

   DIA_TR_INF(" --- handleTimeout : VIDEO SOURCE CONTROL --- 0 !!!!");
   dia_IVideoSourceControl* pInterface = 0;
   if ( (querySysAdapterInterface<dia_IVideoSourceControl>(&pInterface) == DIA_SUCCESS) && pInterface )
   {
      DIA_TR_INF(" --- handleTimeout : VIDEO SOURCE CONTROL --- 1 !!!!");
      //(tVoid) setSysAdapterListener<dia_IVideoSourceControlListener>(this);
      pInterface->resetFSMTimeout();
   }
   else
   {
	   DIA_TR_INF(" --- handleTimeout : VIDEO SOURCE CONTROL --- 3 !!!!");
   }
//   (void) unsetSysAdapterListener<dia_IVideoManagerListener>(this);
   (void) unsetSysAdapterListener<dia_IVideoSourceControlListener>(this);
}



//
//void
//   dia_IOCtrlVideoSourceSet::vOnComponentResponse( const int compResponse)
//{
//   dia_tclFnctTrace trc("dia_IOCtrlVideoSourceSet::vOnComponentResponse");
//#if 0
//   tBool errorDetected = TRUE;
//
//   switch((dia_tcompResponseState)compResponse)
//   {
//   case VID_M_ACTIVE_MEDIA:
//   case VID_M_ACTIVE_DVD:
//   case VID_M_ACTIVE_RVCONPOPUP:
//   case VID_M_ACTIVE_RVCONHMI:
//   case VID_M_ACTIVE_SPI:
//   case VID_M_ACTIVE_NAVI:
//   case VID_M_ACTIVE_NORMAL_HMI:
//
//      DIA_TR_INF("in switch case!");
//
//      if(mVidDestId == (dia_tVideoDestId)compResponse)
//      {
//         DIA_TR_INF("mVidDestId == (dia_tVideoDestId)compResponse");
//         //send positive response and exit
//      }
//      else
//      {
//         DIA_TR_INF("mVidDestId != (dia_tVideoDestId)compResponse");
//
//         dia_IVideoManager* pInterface = 0;
//         if ((querySysAdapterInterface<dia_IVideoManager>(&pInterface) == DIA_SUCCESS) && pInterface) {
//
//            (void) setSysAdapterListener<dia_IVideoManagerListener>(this);
//
//            DIA_TR_INF("mVidDestId  %d.", mVidDestId);
//
//            if (pInterface->disconnectVideoSource((dia_tVideoDestId)compResponse, DIA_EN_VIDEO_FRONT_DISPLAY) == DIA_SUCCESS) {
//
//               errorDetected = FALSE;
//
//            } else {
//               DIA_TR_ERR("dia_IOCtrlVideoSourceSet::vOnComponentResponse => Error: disconnectVideoSource failed !");
//            }
//
//         } else {
//            DIA_TR_ERR("dia_IOCtrlVideoSourceSet::vOnComponentResponse => Error: Cannot get dia_IVideoManager !");
//         }
//
//
//
//      }
//      break;
//
//   case VID_M_VID_SRC_DISCONNECTED:
//
//      DIA_TR_ERR("dia_IOCtrlVideoSourceSet::vOnComponentResponse VID_M_VID_SRC_DISCONNECTED");
//
//      if(DIA_EN_VIDEO_DVD_VIDEO_REQ == mVidDestId) /*REMOVE MAGIC NUMBER: rva5cob*/
//      {
//         dia_IVideoManager* pInterface = 0;
//         if ((querySysAdapterInterface<dia_IVideoManager>(&pInterface) == DIA_SUCCESS) && pInterface) {
//
//            (void) setSysAdapterListener<dia_IVideoManagerListener>(this);
//
//            if (pInterface->connectVideoSource(DIA_EN_VIDEO_DEST_DVD, DIA_EN_VIDEO_FRONT_DISPLAY) == DIA_SUCCESS) {
//
//               errorDetected = FALSE;
//
//            } else {
//               DIA_TR_ERR("dia_IOCtrlVideoSourceSet::vOnComponentResponse => Error: dvdVideoStartStreamingRequest failed !");
//            }
//
//         } else {
//            DIA_TR_ERR("dia_IOCtrlVideoSourceSet::vOnComponentResponse => Error: Cannot get dia_IDVDPlayerListener !");
//         }
//      }
//      else if(2 == mVidDestId)//for rvc
//      {
//      }
//      else if(1 == mVidDestId)//Normal HMI
//      {
//      }
//
//
//      break;
//
//
//   case VID_M_DVD_CONNECTED:
//      DIA_TR_INF("VID_M_DVD_CONNECTED");
//
//      (void) unsetSysAdapterListener<dia_IVideoManagerListener>(this);
//
//      if(3 == mVidDestId) /*REMOVE MAGIC NUMBER: rva5cob*/
//      {
//         dia_IDVDPlayer* pInterface = 0;
//         if ((querySysAdapterInterface<dia_IDVDPlayer>(&pInterface) == DIA_SUCCESS) && pInterface) {
//
//            (void) setSysAdapterListener<dia_IDVDPlayerListener>(this);
//
//            if (pInterface->dvdVideoStartStreamingRequest() == DIA_SUCCESS) {
//
//               errorDetected = FALSE;
//
//            } else {
//               DIA_TR_ERR("dia_IOCtrlVideoSourceSet::vOnComponentResponse => Error: dvdVideoStartStreamingRequest failed !");
//            }
//
//         } else {
//            DIA_TR_ERR("dia_IOCtrlVideoSourceSet::vOnComponentResponse => Error: Cannot get dia_IDVDPlayerListener !");
//         }
//      }
//      else if(2 == mVidDestId)//for rvc
//      {
//      }
//      else if(1 == mVidDestId)//Normal HMI
//      {
//      }
//
//
//
//
//      break;
//
//
//
//
//   default:
//      DIA_TR_INF("default case!");
//
//   }
//
//#endif
//
//}
