/*
 * dia_IOCtrlUSB_PowerSupply.h
 *
 * Created on: 05.06.2014
 * Author: nce5kor
 *
 */

#ifndef DIA_IOCTRLUSB_POWERSUPPLY_H_
#define DIA_IOCTRLUSB_POWERSUPPLY_H_


#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DEVICEMGRUSB_LISTENER__
#include "common/interfaces/dia_IDeviceMGRUSBListener.h"
#endif

class dia_IOCtrlUSB_PowerSupply
   : public dia_IOCtrlSignal,
     public dia_IDeviceMGRUSBListenerImpl
{

   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_IOCtrlUSB_PowerSupply);
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_IOCtrlUSB_PowerSupply);
public:
   //! class constructor
   dia_IOCtrlUSB_PowerSupply ( enum dia_eUsbDevice );
   //! class destructor
   virtual ~dia_IOCtrlUSB_PowerSupply ( void );

   //! start processing of the received request
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //! timeout occured during processing of the diagnosis request
   virtual void handleTimeout ( void );

   //! result on the USBPowerSupply_Set call.
   virtual void vOnUSBPowerStatusResult(tU8 powerSupply);

   //! error on the USBPowerSupply_Set call.
   virtual void vOnUSBPowerStatusError(void);

protected:
   //!
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

   //! USB device number (1 or 2 or 3)
   dia_eUsbDevice mUsbDev;

   // requested power status
   dia_eUsbPowerStatus mUsbPowerStatus;
};

#endif /* DIA_IOCTRLUSB_POWERSUPPLY_H_ */
