/*
 * dia_IOCtrlUSB_PowerSupply.cpp
 *
 * Created on: 05.06.2014
 * Author: nce5kor
 *
 * TTFis:> DIA_REQ UDS 07 2F 64 20 03 0x
 *                                  (00) -> usb power OFF
 *                                  (01) -> usb power ON
 */

/*------------------------------------------------------------------------------------------------------
* Date         | Author                        | Modification
* 27.05.14     | jse5kor(Jeba Satheesh)        | IoControl mode changed to DIA_EN_IOCTRL_CTRLMODE_TESTER
*
********************************************************************************************************/

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"
#include "dia_IOCtrlUSB_PowerSupply.h"

//-----------------------------------------------------------------------------

dia_IOCtrlUSB_PowerSupply::dia_IOCtrlUSB_PowerSupply(enum dia_eUsbDevice usbDev) :
      dia_IOCtrlSignal( (USB_DEVICE_1==usbDev) ? DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_1 : ((USB_DEVICE_2==usbDev) ? DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_2 : ((USB_DEVICE_3==usbDev) ? DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_3 : 0xFFFF /*unknown*/)),
            (USB_DEVICE_1==usbDev) ? DIA_EN_IOCTRL_SIGTYPE_USB_POWER_SUPPLY_1 : ((USB_DEVICE_2==usbDev) ? DIA_EN_IOCTRL_SIGTYPE_USB_POWER_SUPPLY_2 : DIA_EN_IOCTRL_SIGTYPE_USB_POWER_SUPPLY_3),
            1,/* Payload */
            DIA_EN_IOCTRL_CTRLMODE_TESTER),
            mUsbDev(usbDev),
            mUsbPowerStatus(USB_POWER_UNKNOWN)
{
   dia_tclFnctTrace trc("dia_IOCtrlUSB_PowerSupply::dia_IOCtrlUSB_PowerSupply");
}

//-----------------------------------------------------------------------------

dia_IOCtrlUSB_PowerSupply::~dia_IOCtrlUSB_PowerSupply ( void )
{
//   dia_tclFnctTrace trc("dia_IOCtrlUSB_PowerSupply::~dia_IOCtrlUSB_PowerSupply");

   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR( ("EXCEPTION CAUGHT: dia_IOCtrlUSB_PowerSupply::~dia_IOCtrlUSB_PowerSupply !!!") );
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlUSB_PowerSupply::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace trc("dia_IOCtrlUSB_PowerSupply::handleRequest");

   dia_IDeviceMGRUSB* pIDeviceMgrUSB = NULL;
   mUsbPowerStatus = USB_POWER_UNKNOWN;

   tBool errorDetected = FALSE;

   if ((USB_DEVICE_UNKNOWN==mUsbDev) || (mUsbDev>=USB_DEVICE_COUNT))
   {
      DIA_TR_ERR("### dia_IOCtrlUSB_PowerSupply::handleRequest mUsbDev=0x%02X is incorrect.", mUsbDev);
      return DIA_FAILED;
   }

   if (querySysAdapterInterface<dia_IDeviceMGRUSB>(&pIDeviceMgrUSB) == DIA_SUCCESS)
   {
      DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::handleRequest - querySysAdapterInterface<dia_IDeviceMGRUSB> OK");
      if (pIDeviceMgrUSB)
      {
         DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::handleRequest - pIDeviceMgrUSB OK");
         (void)setSysAdapterListener<dia_IDeviceMGRUSBListener>(this);
         switch( ctrlValue->at( 0 ) )
         {
            case 0x00:
            {
               DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::handleRequest set USB POWER to OFF");
               mUsbPowerStatus = USB_POWER_OFF;
            }
            break;

            default:
            {
               DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::handleRequest set USB POWER to ON");
               mUsbPowerStatus = USB_POWER_ON;
            }
            break;
         }

         if (pIDeviceMgrUSB->setUSBPowerStatus(mUsbDev, mUsbPowerStatus) != DIA_SUCCESS)
         {
            errorDetected = TRUE;
            DIA_TR_ERR("### dia_IOCtrlUSB_PowerSupply::handleRequest: pIDeviceMgrUSB failed");
         }
         else
         {
            DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::handleRequest USB POWER SET SUCCESS");
         }
      }
      else
      {
         DIA_TR_ERR("### dia_IOCtrlUSB_PowerSupply::handleRequest pIDeviceMgrUSB is NULL.");
      }
   }
   else
   {
      //errorDetected = TRUE;
      DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::handleRequest - querySysAdapterInterface<dia_IDeviceMGRUSB> NOT OK ");
      DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::handleRequest - pIDeviceMgrUSB NOT OK");
   }

   if( errorDetected )
   {
      (void)unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);
      DIA_TR_ERR("dia_IOCtrlUSB_PowerSupply - SEND TO VD_DEVICEMANAGER SERVER FAILED !!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer( DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE );

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;

}

//----------------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlUSB_PowerSupply::vOnTerminate( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlUSB_PowerSupply::vOnTerminate()");
   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE)
   {
      DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::vOnTerminate DIA_EN_IOCTRL_STATUS_ACTIVE");

      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
         DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::vOnTerminate DIA_EN_IOCTRL_STATUS_INACTIVE");

         // we have to wait for the response
         mIsResultReady = FALSE;
      }
      // potential message sending to component
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//----------------------------------------------------------------------------------------

void
dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusResult( tU8 usbPowerStatus )
{
   dia_tclFnctTrace trc( "dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusResult" );

   (void) unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);

   if ((USB_DEVICE_UNKNOWN==mUsbDev) || (mUsbDev>=USB_DEVICE_COUNT))
   {
      DIA_TR_ERR("### dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusResult mUsbDev=0x%02X is incorrect.", mUsbDev);
      return;
   }

   tDiaResult retCode = DIA_FAILED;

   mIsResultReady = TRUE;

   DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusResult usbPowerStatus=0x%02X.", usbPowerStatus);

   //check status mask: usbPowerStatus is the same byte what has been sent in the request to Device Manager.
   if ((USB_POWER_OFF==mUsbPowerStatus) && (0==usbPowerStatus))
   {
      DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusResult usbPowerStatus is zero because USB port was switched off.");
      retCode = DIA_SUCCESS;
   }
   else if ((USB_POWER_ON==mUsbPowerStatus) && (0!=(usbPowerStatus & (1<<(mUsbDev-USB_DEVICE_1)))))
   {
      DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusResult usbPowerStatus is not zero because USB port was switched on.");
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("### dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusResult Incorrect status of USB port.");
      DIA_TR_ERR("### dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusResult mUsbPowerStatus=0x%02X mUsbDev=0x%02X.", mUsbPowerStatus, mUsbDev);
   }

   if (DIA_SUCCESS!=retCode)
   {
      DIA_TR_ERR("### dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusResult exp mUsbPowerStatus=0x%02X, act 0x%02X.", 0, usbPowerStatus);
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
   }
   else
   {
      DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusResult actual value is equal to expected value.");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//----------------------------------------------------------------------------------------

void
dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusError( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusError");

   (void)unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);
   mIsResultReady = TRUE;

   DIA_TR_INF("dia_IOCtrlUSB_PowerSupply::vOnUSBPowerStatusError (NEGATIVE RESULT FROM SA).");
   setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

}

//----------------------------------------------------------------------------------------

void
dia_IOCtrlUSB_PowerSupply::handleTimeout ( void )
{
   dia_tclFnctTrace trc( "dia_IOCtrlUSB_PowerSupply::handleTimeout" );
   (void)unsetSysAdapterListener<dia_IDeviceMGRUSBListener>(this);
}

