/*
 * dia_IOCtrlTunerDAB_Antenna_1_ServiceID.cpp
 *
 *  Created on: 15.10.2012
 *      Author: shw2abt
 */
// TTFis:> DIA_REQ UDS 06 2F 61 32 03 FF FF FF FF

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include "../../../depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#include "dia_IOCtrlTunerDAB_Antenna_1_ServiceID.h"

//-----------------------------------------------------------------------------

dia_IOCtrlTunerDAB_Antenna_1_ServiceID::dia_IOCtrlTunerDAB_Antenna_1_ServiceID(tVoid) :
      dia_IOCtrlSignalRestrictedToRemoteControl(
          DIA_C_U16_DID_RBCM_TUNER_DAB_SERVICE_ID,
          DIA_EN_IOCTRL_SIGTYPE_TUNERDAB_ANT1_SERVICE_ID,
          4 /* Payload */
      )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDAB_Antenna_1_ServiceID::dia_IOCtrlTunerDAB_Antenna_1_ServiceID");
}

//-----------------------------------------------------------------------------

dia_IOCtrlTunerDAB_Antenna_1_ServiceID::~dia_IOCtrlTunerDAB_Antenna_1_ServiceID ( tVoid )
{
//   dia_tclFnctTrace trc("dia_IOCtrlTunerDAB_Antenna_1_ServiceID::~dia_IOCtrlTunerDAB_Antenna_1_ServiceID");

   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerDABControlListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlTunerDAB_Antenna_1_ServiceID::~dia_IOCtrlTunerDAB_Antenna_1_ServiceID !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerDAB_Antenna_1_ServiceID::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDAB_Antenna_1_ServiceID::handleRequest");
   tBool errorDetected = TRUE;

   tU32 serviceID = U8_2_U32(ctrlValue->at(0),ctrlValue->at(1),ctrlValue->at(2),ctrlValue->at(3)); //lint !e864 Info: expression possibly depends on order of evaluation

   DIA_TR_INF("dia_IOCtrlTunerDAB_Antenna_1_ServiceID::handleRequest serviceID = 0x%04x",serviceID);
   dia_ITunerDABControl* pInterface = 0;
   if (querySysAdapterInterface<dia_ITunerDABControl>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_ITunerDABControlListener>(this);
         if (pInterface->tunerDAB_ServiceID_Set(serviceID) == DIA_SUCCESS) {
            DIA_TR_INF("dia_IOCtrlTunerDAB_Antenna_1_ServiceID::handleRequest: PowerMode_Set SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_IOCtrlTunerDAB_Antenna_1_ServiceID::handleRequest: PowerMode_Set FAILED.");
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ITunerDABControlListener>(this);
      DIA_TR_ERR("dia_IOCtrlTunerDAB_Antenna_1_ServiceID --- SEND TO TUNER DAB CONTROL FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tVoid dia_IOCtrlTunerDAB_Antenna_1_ServiceID::vOnTunerDABServiceID_Set ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDAB_Antenna_1_ServiceID::vOnTunerDABPowerSupply_Set");

   if (success == DIA_SUCCESS) {
      (tVoid) unsetSysAdapterListener<dia_ITunerDABControlListener>(this);
      mIsResultReady = TRUE;
      DIA_TR_INF("dia_IOCtrlTunerDAB_Antenna_1_ServiceID::vOnTunerDABPowerSupply_Set SUCCESS.");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlTunerDAB...ServiceID::vOnTunerDABPowerSupply_Set NEGATIVE RESULT FROM SA!!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//----------------------------------------------------------------------------------------

tVoid dia_IOCtrlTunerDAB_Antenna_1_ServiceID::handleTimeout(tVoid)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDAB_Antenna_1_ServiceID::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_ITunerDABControlListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult dia_IOCtrlTunerDAB_Antenna_1_ServiceID::vOnTerminate(dia_eIOCtrlStatus /*status*/)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerDAB_Antenna_1_ServiceID::vOnTerminate()");

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   return DIA_E_NOERROR;
}
