/*
 * dia_IOCtrlTunerAMFM_Frequency.cpp
 *
 *  Created on: 15.10.2012
 *      Author: shw2abt
 */
//TTFis:> DIA_REQ UDS 09 2F 61 01 03 11 22 33 44

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#include "common/services/uds/production/dia_IOCtrlTunerAMFM_Frequency.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
//#define DATA_LENGTH 2

//------------------------------------------------------------------------------

dia_IOCtrlTunerAMFM_Frequency::dia_IOCtrlTunerAMFM_Frequency(void) :
   dia_IOCtrlSignalRestrictedToRemoteControl(
            DIA_C_U16_DID_RBCM_TUNER_AMFM_FREQUENCY,
            DIA_EN_IOCTRL_SIGTYPE_TUNER_SET_FREQUENCY_AMFM,
            4 /* Payload Length */
            )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlTunerAMFM_Frequency::~dia_IOCtrlTunerAMFM_Frequency(void)
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlTunerAMFM_Frequency::~dia_IOCtrlTunerAMFM_Frequency !!!");
      DIA_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

 //------------------------------------------------------------------------------

//lint -e715 shw2abt: timerValue is not used in this context
tDiaResult
dia_IOCtrlTunerAMFM_Frequency::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerAMFM_Frequency::handleRequest(tU8,vector<tU8>*)");
   tBool errorDetected = TRUE;

   DIA_TR_INF("dia_IOCtrlTunerAMFM_Frequency::handleRequest: start Handling.");
   dia_ITunerAMFM* pInterface = 0;
   if (querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         tU32 newFrequency = U8_2_U32(ctrlValue->at(0),ctrlValue->at(1),ctrlValue->at(2),ctrlValue->at(3)); //lint !e864 Info: expression possibly depends on order of evaluation

         // convert: CANoe sends in Hz <-> FI expects kHz
         newFrequency = newFrequency/1000;

         (void) setSysAdapterListener<dia_ITunerAMFMListener>(this);
         if (pInterface->tunerAMFM_Frequency_Set(newFrequency) == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      DIA_TR_ERR(" ---  SEND TO TUNER SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}
//lint +e715

//------------------------------------------------------------------------------

tDiaResult dia_IOCtrlTunerAMFM_Frequency::vOnTerminate(dia_eIOCtrlStatus status)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerAMFM_Frequency::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_ITunerAMFM* pInterface = 0;
      if (querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (void) setSysAdapterListener<dia_ITunerAMFMListener>(this);
            if (pInterface->tunerAMFM_Frequency_Set(0) != DIA_SUCCESS) {
               DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SELECTAUDIOTRACK !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

void dia_IOCtrlTunerAMFM_Frequency::vOnTunerAMFMFrequency_Set ( tDiaResult success  )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerAMFM_Frequency::vOnTunerAMFMFrequency_Set");
   
   (void) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlTunerAMFM_Frequency::vOnTunerAMFMFrequency_Set SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlTunerAMFM_Frequency::vOnTunerAMFMFrequency_Set DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

void dia_IOCtrlTunerAMFM_Frequency::handleTimeout(void)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerAMFM_Frequency::handleTimeout");
   (void) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
}

