/*
 * dia_IOCtrlTunerAMFM_Band.cpp
 *
 *  Created on: 17.10.2012
 *      Author: shw2abt
 */
//TTFis:> DIA_REQ UDS 06 2F 61 02 03 01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlTunerAMFM_Band.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
//#define DATA_LENGTH 2

//------------------------------------------------------------------------------

dia_IOCtrlTunerAMFM_Band::dia_IOCtrlTunerAMFM_Band(tVoid) :
   dia_IOCtrlSignalRestrictedToRemoteControl(
            0x6102,
            DIA_EN_IOCTRL_SIGTYPE_TUNER_SET_BAND_AMFM,
            1 /* Payload Length */
            )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlTunerAMFM_Band::~dia_IOCtrlTunerAMFM_Band(tVoid)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlTunerAMFM_Band::~dia_IOCtrlTunerAMFM_Band !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

 //------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerAMFM_Band::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerAMFM_Band::handleRequest(tU8,vector<tU8>*)");
   tBool errorDetected = TRUE;

   dia_ITunerMaster* pInterface = 0;
   if (querySysAdapterInterface<dia_ITunerMaster>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         dia_eBand newBand = DIA_EN_TUNERMASTER_BAND_UNKNOWN;
         switch(ctrlValue->at(0)){
         case 0x01:
            newBand = DIA_EN_TUNERMASTER_BAND_FM;
            break;
         case 0x02:
            newBand = DIA_EN_TUNERMASTER_BAND_AM;
            break;
         default:
            newBand = DIA_EN_TUNERMASTER_BAND_UNKNOWN;
            DIA_TR_ERR("dia_IOCtrlTunerAMFM_Band::handleRequest UNKNOWN TUNER BAND.");
            break;
         }

         (tVoid) setSysAdapterListener<dia_ITunerMasterListener>(this);
         if (pInterface->tunerAMFM_TunerBand_Set(newBand) == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
      DIA_TR_ERR(" ---  SEND TO TUNER SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerAMFM_Band::vOnTerminate(dia_eIOCtrlStatus status)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerAMFM_Band::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_ITunerMaster* pInterface = 0;
      if (querySysAdapterInterface<dia_ITunerMaster>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (tVoid) setSysAdapterListener<dia_ITunerMasterListener>(this);
            if (pInterface->tunerAMFM_ActiveTuner_Set(DIA_EN_TUNERMASTER_UNKNOWN) != DIA_SUCCESS) {
               DIA_TR_ERR("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SELECT TUNER BAND !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_IOCtrlTunerAMFM_Band::vOnTunerAMFMTunerBand_Set ( tDiaResult success  )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerAMFM_Band::vOnTunerAMFMTunerBand_Set");
   
   (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlTunerAMFM_Band::vOnTunerAMFMTunerBand_Set SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlTunerAMFM_Band::vOnTunerAMFMTunerBand_Set DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid dia_IOCtrlTunerAMFM_Band::handleTimeout(tVoid)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerAMFM_Band::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
}

