#ifndef __INCLUDED_DIA_IOCTRL_SYSTEM_HMI_ON__
#define __INCLUDED_DIA_IOCTRL_SYSTEM_HMI_ON__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include "common/interfaces/dia_ISpmListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlSystemHmiOn
	: public dia_IOCtrlSignal,
	  public dia_ISpmListenerImpl
{
public:
   //! class constructor
	   dia_IOCtrlSystemHmiOn ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrlSystemHmiOn ( tVoid );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual tVoid handleTimeout ( tVoid );
   //! set the status of the IOCtrl signal
   virtual tVoid eSetStatus ( dia_eIOCtrlStatus newStatus );

   //! acknowledge that the diagnosis activity substate was entered
   virtual tVoid vOnSubstateAck ( tVoid );

   //! method to retrieve current status of this signal directly
   static tBool getIOCtrlStatus ( tVoid );

   //! method to retrieve current value of this signal directly
   static tBool getIOCtrlValue ( tVoid );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

protected:
   //! status of this signal. Activate = TRUE, not active = FALSE
   static tBool mIOCtrlStatus;
   //! value of this signal. Activate = TRUE, not active = FALSE
   static tBool mIOCtrlValue;
};

#endif
