/*
 * dia_IOCtrlRVCControlLine.h
 *
 *  Created on: 22.01.2013
 *      Author: shw2abt
 */

#ifndef DIA_IOCTRLRVCCONTROLLINE_H_
#define DIA_IOCTRLRVCCONTROLLINE_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_RVCCONTROL_LISTENER__
#include "common/interfaces/dia_IRVCControlListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlRVCControlLine: public dia_IOCtrlSignal, public dia_IRVCControlListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlRVCControlLine(tVoid);
   //! class destructor
   virtual ~dia_IOCtrlRVCControlLine(tVoid);

   //! handle freeze request
   virtual tDiaResult handleFreeze ( tVoid );
   //! short term adjustment for RVC Control Line
   virtual tDiaResult handleRequest(tU8 timerValue, std::vector<tU8>* ctrlValue);
   //! the timer of the associated service handler has been elapsed
   virtual tVoid handleTimeout(tVoid);
   //! response from component about success of activate Freeze
   virtual tVoid vOnRVCControlLineFreezeMode (tDiaResult success, dia_eRVCControl_ControlLineFreeze freezeMode, tU8 enableMode);
   //! Signal to inform requester about success of the setRVCControl_ControlLine change request
   virtual tVoid vOnRVC_ControlLine(tDiaResult success);

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate(dia_eIOCtrlStatus status);

};

#endif /* DIA_IOCTRLRVCCONTROLLINE_H_ */
