/****************************************************************************************
* dia_IOCtrlInputHdlPressedKey.cpp
*
*  Created on: 18.02.2014
*      Author: wgl2hi

// DIA_REQ UDS 06 2F 62 30 03 zz zz -> 2 bytes of keycode

 ---------------------------------------------------------------------------------------
 * Date 	       | Author	          | Modification
 * 1.12.15         | ata7kor          | Added a new code to resolve ticket AIVI-15132
 *---------------------------------------------------------------------------------------
 *  
 ****************************************************************************************/
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_IOCtrlInputHdlPressedKey.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#define DIA_KEYCODE_UNKNOWN     0xFFFF
#define DIA_KEYCODE_PHONE		0x0300
#define DIA_KEYCODE_CD			0x0301
#define DIA_KEYCODE_CAMERA		0x0302
#define DIA_KEYCODE_AUX			0x0303
#define DIA_KEYCODE_PREV		0x0304
#define DIA_KEYCODE_NEXT		0x0305
#define DIA_KEYCODE_RADIO		0x0306
#define DIA_KEYCODE_INFO		0x0307
#define DIA_KEYCODE_SETUP		0x0308
#define DIA_KEYCODE_MAP			0x0309
#define DIA_KEYCODE_BACK		0x030A
#define DIA_KEYCODE_DAY_NIGHT   0x030B
#define DIA_KEYCODE_NAV         0x030C
#define DIA_KEYCODE_ENTER		0x030D
#define DIA_KEYCODE_XM		    0x030E
#define DIA_KEYCODE_AM_FM		0x0311
#define DIA_KEYCODE_MENU		0x0312
#define DIA_KEYCODE_APP         0x0313
#define DIA_KEYCODE_AUDIO       0x0314
#define DIA_KEYCODE_DISP        0x0315
#define DIA_KEYVIRTUAL_STM      0x03A0
#define DIA_KEYCODE_POWER       0x030F
#define DIA_KEYCODE_EJECT		0x0310
#define DIA_SWCCODE_OK		    0X0065
#define DIA_SWCCODE_SEEK_UP     0X0066
#define DIA_SWCCODE_SEEK_DOWN   0X0067
#define DIA_SWCCODE_TEL_VR      0X0068
#define DIA_SWCCODE_VOLUME_DOWN 0X006A
#define DIA_SWCCODE_VOLUME_UP   0X006B
#define DIA_SWCCODE_TEL_HANGUP  0X006C
#define DIA_SWCCODE_BACK        0X006D
#define DIA_SWCCODE_UP          0X006F
#define DIA_SWCCODE_DOWN        0X0070
//------------------------------------------------------------------------------

dia_IOCtrlInputHdlPressedKey::dia_IOCtrlInputHdlPressedKey ( void )
: dia_IOCtrlSignal ( DIA_C_U16_DID_RBCM_INPUT_HDL_KEY_PRESSED,
                     DIA_EN_IOCTRL_SIGTYPE_IPSIM_PRESSED_KEY,
                     2,
                     DIA_EN_IOCTRL_CTRLMODE_TESTER ),
   bPressDone(FALSE),
   u16KeyCode(0x0000),
   KeyID(DIA_KEY_CODE_UNKNOWN)
{
}

//------------------------------------------------------------------------------

dia_IOCtrlInputHdlPressedKey::~dia_IOCtrlInputHdlPressedKey ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlInputHdlPressedKey::~dia_IOCtrlInputHdlPressedKey !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlInputHdlPressedKey::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlInputHdlPressedKey::handleRequest");

   tDiaResult retVal = DIA_SUCCESS;
   bPressDone = FALSE;
   tBool errorDetected = TRUE;

   u16KeyCode = ctrlValue->at(1);
   u16KeyCode = u16KeyCode | tU16(ctrlValue->at(0) << 8);
   dia_IInputHandling* pInterface = 0;

   KeyID=getInputHandlingKeyCode(u16KeyCode);
   if ( (querySysAdapterInterface<dia_IInputHandling>(&pInterface) == DIA_SUCCESS) && pInterface )
   {	
	   if ( KeyID != DIA_KEY_CODE_UNKNOWN )
	   {
          (void) setSysAdapterListener<dia_IInputHandlingListener>(this);
          if ( DIA_SUCCESS == (pInterface->setKeyInternalCode(KeyID ,DIA_EN_KEY_INFO_PRESSED)) )
          {
			  errorDetected = FALSE;
          }
	   }
   }
   if(errorDetected)
   {
      (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
      DIA_TR_ERR("dia_IOCtrlInputHdlPressedKey::handleRequest - SEND TO IPSIM FAILED!!!!");
      retVal = DIA_E_CONDITIONS_NOT_CORRECT;
   }
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);
   mIsResultReady = FALSE;

   return retVal;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlInputHdlPressedKey::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlInputHdlPressedKey::handleTimeout");
   (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlInputHdlPressedKey::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlInputHdlPressedKey::vOnTerminate()");

   tDiaResult retVal = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE )
      {
         // wait for the response
         mIsResultReady = FALSE;
      }
   }

   eSetStatus(status);

   return retVal;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlInputHdlPressedKey::vOnSetKey ( const tDiaResult eDiaResult )
{
   dia_tclFnctTrace trc("dia_IOCtrlInputHdlPressedKey::vOnSetKey");

   tBool errorDetected = FALSE;
   dia_IInputHandling* pInterface = 0;
   if ((eDiaResult == DIA_SUCCESS) && ((querySysAdapterInterface<dia_IInputHandling>(&pInterface)) == DIA_SUCCESS) && pInterface)
   {
      if ((!bPressDone) && (KeyID != DIA_KEY_CODE_UNKNOWN ))
	  {
         bPressDone = TRUE;
         OSAL_s32ThreadWait(200);

		  if (DIA_SUCCESS == pInterface->setKeyInternalCode(KeyID ,DIA_EN_KEY_INFO_RELEASED))
         {
			  DIA_TR_INF("dia_IOCtrl_PressedKey::vOnSetKey - (MODE_PRESSED) SUCCESS.");			  
         }
	      else
	      {
			 errorDetected = TRUE;
	  }
	   }
	  else
	  {
         mIsResultReady = TRUE;
		(void) unsetSysAdapterListener<dia_IInputHandlingListener>(this); 
		 dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
	  }
   }
	else
	{
		errorDetected = TRUE;
	}

    if(errorDetected)
	{
		mIsResultReady = TRUE;
   (void) unsetSysAdapterListener<dia_IInputHandlingListener>(this);
		setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT); 
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
	}
 }
//-----------------------------------------------------------------------------

dia_eVdInuptHandlingKeyCode 
dia_IOCtrlInputHdlPressedKey::getInputHandlingKeyCode ( tU16 KeyCode )  
 {
	 dia_tclFnctTrace trc("dia_IOCtrlInputHdlPressedKey::getInputHandlingKeyCode");
	 KeyID= DIA_KEY_CODE_UNKNOWN;
	  switch(u16KeyCode)
	  {
			case DIA_KEYCODE_PHONE:
				 KeyID = DIA_KEY_CODE_PHONE;
				 break;
			case DIA_KEYCODE_CD:
				 KeyID = DIA_KEY_CODE_CD;
				 break;
			case DIA_KEYCODE_CAMERA:
				 KeyID = DIA_KEY_CODE_CAMERA;
				 break;
			case DIA_KEYCODE_AUX:
				 KeyID = DIA_KEY_CODE_AUX;
				 break;
			case DIA_KEYCODE_PREV:
				 KeyID = DIA_KEY_CODE_PREV;
				 break;
			case DIA_KEYCODE_NEXT:
				 KeyID = DIA_KEY_CODE_NEXT;
				 break;
			case DIA_KEYCODE_RADIO:
				 KeyID = DIA_KEY_CODE_RADIO;
				 break;
		    case DIA_KEYCODE_INFO:
				 KeyID = DIA_KEY_CODE_INFO;
				 break;
			case DIA_KEYCODE_SETUP:
				 KeyID = DIA_KEY_CODE_SETUP;
				 break;
			case DIA_KEYCODE_MAP:
				 KeyID = DIA_KEY_CODE_MAP;
				 break;
            case DIA_KEYCODE_BACK:
				 KeyID = DIA_KEY_CODE_BACK;
				 break;
			case DIA_KEYCODE_DAY_NIGHT:
				 KeyID = DIA_KEY_CODE_DAY_NIGHT;
				 break;
			case DIA_KEYCODE_NAV:
				 KeyID = DIA_KEY_CODE_NAV;
				 break;
			case DIA_KEYCODE_ENTER:
				 KeyID = DIA_KEY_CODE_ENTER;
				 break;
			case DIA_KEYCODE_XM:
				 KeyID = DIA_KEY_CODE_XM;
				 break;
			case DIA_KEYCODE_AM_FM:
				 KeyID = DIA_KEY_CODE_AM_FM;
				 break;
			case DIA_KEYCODE_MENU:
				 KeyID = DIA_KEY_CODE_MENU;
				 break;
			case DIA_KEYCODE_APP:
				 KeyID = DIA_KEY_CODE_APP;
				 break;
			case DIA_KEYCODE_AUDIO:
				 KeyID = DIA_KEY_CODE_AUDIO;
				 break;
			case DIA_KEYCODE_DISP:
				 KeyID = DIA_KEY_CODE_DISP;
				 break;
			case DIA_KEYVIRTUAL_STM:  
				 KeyID = DIA_KEY_VIRTUAL_STM;
				 break;
			case DIA_KEYCODE_POWER:
				 KeyID=DIA_KEY_CODE_POWER ;
				 break;
			case DIA_KEYCODE_EJECT:
				 KeyID = DIA_KEY_CODE_EJECT;
				 break;
			case DIA_SWCCODE_OK:
				 KeyID = DIA_SWC_KEY_CODE_OK;
				 break;
			case DIA_SWCCODE_SEEK_UP:
				 KeyID = DIA_SWC_KEY_CODE_SEEK_UP;
				 break;
			case DIA_SWCCODE_SEEK_DOWN:
				 KeyID = DIA_SWC_KEY_CODE_SEEK_DOWN;
				 break;
			case DIA_SWCCODE_TEL_VR:
				 KeyID = DIA_SWC_KEY_CODE_TEL_VR;
				 break;
			case DIA_SWCCODE_VOLUME_DOWN:
				 KeyID = DIA_SWC_KEY_CODE_VOL_DOWN;
				 break;
			case DIA_SWCCODE_VOLUME_UP:
				 KeyID = DIA_SWC_KEY_CODE_VOL_UP;
				 break;
            case DIA_SWCCODE_TEL_HANGUP:
				 KeyID = DIA_SWC_KEY_CODE_TEL_HANG_UP;
				 break;
			case DIA_SWCCODE_BACK:
				KeyID = DIA_SWC_KEY_CODE_BACK;
				break;
			case DIA_SWCCODE_UP:
				KeyID = DIA_SWC_KEY_CODE_UP;
				break;
			case DIA_SWCCODE_DOWN:
				KeyID = DIA_SWC_KEY_CODE_DOWN;
				break;
			default:
				DIA_TR_INF("No valid value has supplied");
				break;
	}

	 DIA_TR_INF("dia_IOCtrlInputHdlPressedKey::getInputHandlingKeyCode - Code=0x%x  ,KeyID=0x%x",KeyCode,KeyID);
	 return KeyID;
 }
//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlInputHdlPressedKey::triggerKey ( dia_eInputHandlingKeyInfo /*eKeyInfo */) const
{
	tDiaResult retVal = DIA_FAILED;
	/*dia_tclFnctTrace trc("dia_IOCtrlInputHdlPressedKey::triggerKey");

   
   dia_IInputHandling* pInterface = 0;

   if ( querySysAdapterInterface<dia_IInputHandling>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         (void) setSysAdapterListener<dia_IInputHandlingListener>(this);
         retVal = pInterface->setKeyIntern (u16KeyCode, eKeyInfo);
      }
   }
   */
   return retVal;
}
