/*
 * dia_IOCtrlHMILanguage.cpp
 *
 *  Created on: 30.11.2012
 *      Author: gib2hi
 */
//TTFis:\>DIA_REQ UDS 06 2F B1 01 03 01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_IOCtrlHMILanguage.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//------------------------------------------------------------------------------

dia_IOCtrlHMILanguage::dia_IOCtrlHMILanguage ( tVoid )
   : dia_IOCtrlSignalRestrictedToRemoteControl (
         DIA_C_U16_DID_RBCM_HMI_LANGUAGE,
         DIA_EN_IOCTRL_SIGTYPE_HMI_LANGUAGE,
         1 // Payload Length
         )
{
   mLanguageBeforeFreeze = DIA_EN_CM_LANGUAGE_UNKNOWN;
}

//------------------------------------------------------------------------------

dia_IOCtrlHMILanguage::~dia_IOCtrlHMILanguage ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IHMILanguageListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlHMILanguage::~dia_IOCtrlHMILanguage !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlHMILanguage::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlHMILanguage::handleRequest()");
   tBool errorDetected = TRUE;

   dia_IHMILanguage* pInterface = 0;
   if ( querySysAdapterInterface<dia_IHMILanguage>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         (tVoid) setSysAdapterListener<dia_IHMILanguageListener>(this);

         dia_eCMLanguage newLanguage = DIA_EN_CM_LANGUAGE_UNKNOWN;
         switch(ctrlValue->at(0)){
            case 0x01:
               newLanguage = DIA_EN_CM_LANGUAGE_ENGLISH;
               break;
            case 0x02:
               newLanguage = DIA_EN_CM_LANGUAGE_GERMAN;
               break;
            case 0x03:
               newLanguage = DIA_EN_CM_LANGUAGE_PORTUGESE;
               break;
            case 0x04:
               newLanguage = DIA_EN_CM_LANGUAGE_CHINESE;
               break;
            default:
               DIA_TR_ERR("dia_IOCtrlHMILanguage::handleRequest - LANGUAGE ID UNKNOWN.");
               break;
         }

         // save current language
         if (mLanguageBeforeFreeze == DIA_EN_CM_LANGUAGE_UNKNOWN) {
            DIA_TR_INF("dia_IOCtrlHMILanguage::handleRequest - Save current language.");
            pInterface->getHMILanguage();
         }
         // set to new language
         if ( newLanguage != DIA_EN_CM_LANGUAGE_UNKNOWN && pInterface->setHMILanguage(newLanguage) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      } else {
         DIA_TR_ERR("dia_IOCtrlHMILanguage::handleRequest - pInterface FAILED.");
      }
   } else {
      DIA_TR_ERR("dia_IOCtrlHMILanguage::handleRequest - querySysAdapterInterface FAILED.");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IHMILanguageListener>(this);
      DIA_TR_ERR("dia_IOCtrlHMILanguage --- SEND TO TCL SERVICE FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tVoid
dia_IOCtrlHMILanguage::vOnSetHMILanguage ( tDiaResult result )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlHMILanguage::vOnSetHMILanguage()");

   (tVoid) unsetSysAdapterListener<dia_IHMILanguageListener>(this);
   mIsResultReady = TRUE;
   if (result == DIA_SUCCESS) {
      DIA_TR_INF("dia_IOCtrlHMILanguage::vOnSetHMILanguage SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlHMILanguage::vOnSetHMILanguage DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_IOCtrlHMILanguage::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlHMILanguage::vOnTerminate()");
   tDiaResult retCode = DIA_FAILED;

   dia_IHMILanguage* pInterface = 0;
   if (querySysAdapterInterface<dia_IHMILanguage>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_IHMILanguageListener>(this);
         if (mLanguageBeforeFreeze != DIA_EN_CM_LANGUAGE_UNKNOWN) {
            if (pInterface->setHMILanguage(mLanguageBeforeFreeze) == DIA_SUCCESS) {
               retCode = DIA_SUCCESS;
            }
         } else {
            DIA_TR_ERR("dia_IOCtrlHMILanguage::vOnTerminate - NO LANGUAGE IS FROZEN.");
         }
      }
   }
   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlHMILanguage::vOnGetHMILanguage ( dia_eCMLanguage language )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlHMILanguage::vOnGetHMILanguage()");
   mLanguageBeforeFreeze = language;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlHMILanguage::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlHMILanguage::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IHMILanguageListener>(this);
}
