/*
 * dia_IOCtrlGNSSPositioningSystem.cpp
 *
 *  Created on: 29.08.2012
 *      Author:
 */
// DIA_REQ UDS 06 2F 63 05 cc zz

#ifndef DIA_IOCTRL_GNSSPOSITIONINGSYSTEM_H_
#define DIA_IOCTRL_GNSSPOSITIONINGSYSTEM_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_GNSS_LISTENER__
#include "common/interfaces/dia_IGNSSListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlGNSSPositioningSystem
	: public dia_IOCtrlSignal,
	  public dia_IGNSSListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlGNSSPositioningSystem ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrlGNSSPositioningSystem ( tVoid );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual tVoid handleTimeout ( tVoid );   

   virtual tVoid vOnGNSSSatSystem (tU8 u8Mode);

   virtual tDiaResult handleFreeze ( tVoid );

   //virtual tDiaResult handleReturnControlToECU ( tVoid );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus /*status*/ );
   //! Set the emulation mode based on the control state in action
   tDiaResult vSetGnssMode ( dia_eGNSSMode mode );
   //! frozen value used to restore the status in case of return control to ECU
   //tU8 actualState;
};

#endif // DIA_IOCTRL_GNSSPOSITIONINGSYSTEM_H_
