/*
 * dia_IOCtrlDisplayTestPattern.cpp
 *
 *  Created on: 05.09.2012
 *      Author: akn1kor
 */
// DIA_REQ UDS 06 2F 62 02 cc zz zz -> 2 bytes of PWM value

#ifndef DIA_IOCTRL_DISPLAY_TEST_PATTERN_H_
#define DIA_IOCTRL_DISPLAY_TEST_PATTERN_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DISPLAYTEST_LISTENER__
#include "common/interfaces/dia_IDisplayTestListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlDisplayTestPattern
	: public dia_IOCtrlSignal,
	  public dia_IDisplayTestListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlDisplayTestPattern ( void );
   //! class destructor
   virtual ~dia_IOCtrlDisplayTestPattern ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual void handleTimeout ( void );   

   virtual void vOnSetDisplayTestPatternDone ( tDiaResult u32Res );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   
   tDiaResult SetScreen(tU8 u8Screen);
};

#endif // DIA_IOCTRL_DISPLAY_TEST_PATTERN_H_
