/*
 * dia_IOCtrlDisplayBrightness.cpp
 *
 *  Created on: 29.08.2012
 *      Author: akn1kor
 */
// DIA_REQ UDS 06 2F 62 03 cc zz zz -> 2 bytes of PWM value

#ifndef DIA_IOCTRL_DISPLAY_BRIGHTNESS_H_
#define DIA_IOCTRL_DISPLAY_BRIGHTNESS_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_LISTENER__
#include "common/interfaces/dia_IDimmingListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlDisplayBrightness
	: public dia_IOCtrlSignal,
	  public dia_IDimmingListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlDisplayBrightness ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrlDisplayBrightness ( tVoid );

   virtual tDiaResult handleFreeze ( tVoid );
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   virtual tVoid handleTimeout ( tVoid );   

   virtual tVoid vOnEmulationModeStatus (tU8 u8Mode = 0); //lint !e1735: checked that default param is not changed by subclasses

   virtual tVoid vOnDispBrightnessAck (  tU16 u16PWMValue  );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! Set the emulation mode based on the control state in action
   tDiaResult vSetEmulationMode ( dia_eDimEmulationMode mode );
};

#endif // DIA_IOCTRL_DISPLAY_BRIGHTNESS_H_
