/*
 * dia_IOCtrlDisplayBrightness.cpp
 *
 *  Created on: 29.08.2012
 *      Author: akn1kor
 */
// DIA_REQ UDS 06 2F 62 03 zz zz -> 2 bytes of PWM value

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlDisplayBrightness.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//------------------------------------------------------------------------------

dia_IOCtrlDisplayBrightness::dia_IOCtrlDisplayBrightness ( tVoid )
   : dia_IOCtrlSignal (
         DIA_C_U16_DID_RBCM_DISPLAY_BACKLIGHT_ILLUMINATION,
         DIA_EN_IOCTRL_SIGTYPE_DISPLAY_BRIGHTNESS,
         2,
         DIA_EN_IOCTRL_CTRLMODE_TESTER
      )
{}

//------------------------------------------------------------------------------

dia_IOCtrlDisplayBrightness::~dia_IOCtrlDisplayBrightness ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlDisplayBrightness::~dia_IOCtrlDisplayBrightness !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayBrightness::handleFreeze ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlDisplayBrightness::handleFreeze()");

   tDiaResult retCode = vSetEmulationMode(DIA_EN_DIM_EMULATION_MODE_DISPFREEZE);

   if ( retCode == DIA_SUCCESS )
   {
      mIsResultReady = FALSE;
   }
   else
   {
      DIA_TR_INF("FAILED TO FREEZE DISPLAY ILLUMINATION BRIGHTNESS !!!");
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayBrightness::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlDisplayBrightness::handleRequest()");
    
   tBool errorDetected = TRUE;

   dia_IDimming* pInterface = 0;
   if ( querySysAdapterInterface<dia_IDimming>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         tU8  u8PWMByte1  = ctrlValue->at(0);
         tU8  u8PWMByte2  = ctrlValue->at(1);
         tU16 u16PWMValue = (tU16) ((((tU16) u8PWMByte1) << 8) | ((tU16) u8PWMByte2));

         (tVoid) setSysAdapterListener<dia_IDimmingListener>(this);
         if ( pInterface->setDisplayBrightness(u16PWMValue) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
      DIA_TR_ERR(" ---  SEND TO DIMMING SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayBrightness::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlDisplayBrightness::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      retCode = vSetEmulationMode(DIA_EN_DIM_EMULATION_MODE_OFF);
      if ( retCode != DIA_SUCCESS )
      {
         DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SET : DISPLAYBRIGHTNESS !!!");
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlDisplayBrightness::vOnEmulationModeStatus ( tU8 mode )
{
   dia_tclFnctTrace trc("dia_IOCtrlDisplayBrightness::vOnEmulationModeStatus");

   (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);

   switch ( mode )
   {
   case DIA_EN_DIM_EMULATION_MODE_DISPFREEZE:
      (tVoid) dia_IOCtrlSignal::handleFreeze();
      break;

   default:
      break;
   }

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlDisplayBrightness::vOnDispBrightnessAck (  tU16 /*u16PWMValue*/ )
{
   dia_tclFnctTrace trc("dia_IOCtrlDisplayBrightness::vOnDispBrightnessAck");

   (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlDisplayBrightness::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlDisplayBrightness::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IDimmingListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayBrightness::vSetEmulationMode ( dia_eDimEmulationMode mode )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlDisplayBrightness::vSetEmulationMode()");

   tDiaResult retCode = DIA_E_NOERROR;

      dia_IDimming* pInterface = 0;
      if ( querySysAdapterInterface<dia_IDimming>(&pInterface) == DIA_SUCCESS )
      {
         if ( pInterface )
         {
            (tVoid) setSysAdapterListener<dia_IDimmingListener>(this);
            retCode = pInterface->setEmulationMode(mode);
            if ( retCode != DIA_SUCCESS )
            {
               DIA_TR_INF("FAILED TO SET THE EMULATION MODE: DISPLAYBRIGHTNESS !!!");
            }
         }
      }

   return retCode;
}

