/*
 * dia_IOCtrlDatasetBlockSize.cpp
 *
 *  Created on: 10.06.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"
#endif

#include "common/services/uds/production/dia_IOCtrlDatasetBlockSize.h"

//------------------------------------------------------------------------------

dia_IOCtrlDatasetBlockSize::dia_IOCtrlDatasetBlockSize ( void )
   : dia_IOCtrlSignal("dia_IOCtrlDatasetBlockSize", DIA_C_U16_DID_RBCM_DATASET_BLOCK_SIZE, 2)
{}

//------------------------------------------------------------------------------

dia_IOCtrlDatasetBlockSize::~dia_IOCtrlDatasetBlockSize ( tVoid )
{}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDatasetBlockSize::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlDatasetBlockSize::handleRequest(tU8,vector<tU8>*)");

   if ( (!ctrlValue) || (ctrlValue->size() != 2) )
   {
      DIA_TR_INF("dia_IOCtrlDatasetBlockSize::handleRequest - Invalid Control Value");
      setErrorInfo(DIA_E_OUT_OF_RANGE);
   }
   else
   {
      tU16 u16BlockSizeHigh = (tU16) (ctrlValue->at(0) << 8);
      tU16 blockSize = static_cast<tU16>(u16BlockSizeHigh | ctrlValue->at(1));

      DIA_TR_INF("dia_IOCtrlDatasetBlockSize::handleRequest - Setting Dataset Block Size to 0x%04x", blockSize);

      if ( dia_setProperty(DIA_PROP_CM_DATASET_BLOCK_SIZE, (tU32) blockSize) != DIA_SUCCESS )
      {
         DIA_TR_INF("dia_IOCtrlDatasetBlockSize::handleRequest - Failed to set Dataset Block Size");
         setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      }
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   // the iocontrol action is completely processed and now we need to inform the service handler
   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDatasetBlockSize::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlDatasetBlockSize::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
          tU16 blockSize = DIA_C_U16_DATA_DOWNLOAD_BLOCK_MAX_BYTES;

          DIA_TR_INF("dia_IOCtrlDatasetBlockSize::vOnTerminate - Setting Dataset Block Size to 0x%04x", blockSize);

          if ( dia_setProperty(DIA_PROP_CM_DATASET_BLOCK_SIZE, (tU32) blockSize) != DIA_SUCCESS )
          {
             DIA_TR_INF("dia_IOCtrlDatasetBlockSize::vOnTerminate - Failed to set Dataset Block Size");
             setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
          }

          // we must not wait for a response
          mIsResultReady = TRUE;
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlDatasetBlockSize::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlDatasetBlockSize::handleTimeout");
}

//------------------------------------------------------------------------------

void
dia_IOCtrlDatasetBlockSize::getCurrentState ( std::vector<tU8>& results )
{
   dia_tclFnctTrace trc("dia_IOCtrlDatasetBlockSize::getCurrentState");

   tU16 blockSize = DIA_C_U16_DATA_DOWNLOAD_BLOCK_MAX_BYTES;
   if ( dia_getProperty(DIA_PROP_CM_DATASET_BLOCK_SIZE, (tU8*) &blockSize, (tU16) sizeof(blockSize)) != DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlDatasetBlockSize::getCurrentState - Failed to get Dataset Block Size. Using Default value.");
   }

   results.push_back((tU8) (blockSize >> 8));
   results.push_back((tU8) (blockSize));
}
