/*
 * dia_IOCtrlCompressedAudioTitle.h
 *
 *  Created on: 26.03.2014
 *      Author: shw2abt
 */

#ifndef DIA_IOCTRLCOMPRESSEDAUDIOTITLE_H_
#define DIA_IOCTRLCOMPRESSEDAUDIOTITLE_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignalRestrictedToRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_COMPRESSEDAUDIO_LISTENER__
#include "common/interfaces/dia_ICompressedAudioListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlCompressedAudioTitle
   : public dia_IOCtrlSignalRestrictedToRemoteControl,
     public dia_ICompressedAudioListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlCompressedAudioTitle ( void );
   //! class destructor
   virtual ~dia_IOCtrlCompressedAudioTitle ( void );

   virtual tDiaResult checkPayloadCorrectness( tU16 /*realLength*/, std::vector<tU8>* paylValue );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual void handleTimeout ( void );

   //! Signal to inform requester about success of the track change request
   virtual void vOnSelectTrackResult ( tDiaResult  );

   //! Member variables
   dia_eCompAudioSource mAudioSource;

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
};

#endif /* DIA_IOCTRLCOMPRESSEDAUDIOTITLE_H_ */
