/*
 * dia_IOCtrlCompressedAudioTitle.cpp
 *
 *  Created on: 26.03.2014
 *      Author: shw2abt
 */
//TTFis> CD Testfile /dev/media/rfs/cdrom/Mix/ThemeSong-JamesBond.mp3
// 0F FF 02 C8 00 01 3C 2F 64 16 03 2F 64 65 76 2F 6D 65 64 69 61 2F 72 66 73 2F 63 64 72 6F 6D 2F 4D 69 78 2F 54 68 65 6D 65 53 6F 6E 67 2D 4A 61 6D 65 73 42 6F 6E 64 2E 6D 70 33

//TTFis> CD Testfile file:///dev/media/rfs/cdrom/Mix/ThemeSong-JamesBond.mp3
// 0F FF 02 C8 00 01 3C 2F 64 16 03 66 69 6C 65 3A 2F 2F 2F 64 65 76 2F 6D 65 64 69 61 2F 72 66 73 2F 63 64 72 6F 6D 2F 4D 69 78 2F 54 68 65 6D 65 53 6F 6E 67 2D 4A 61 6D 65 73 42 6F 6E 64 2E 6D 70 33

//TTFis> CD Testfile /mnt/cdrom/Mix/ThemeSong-JamesBond.mp3
// 0F FF 02 C8 00 01 3C 2F 64 16 03 2F 6D 6E 74 2F 63 64 72 6F 6D 2F 4D 69 78 2F 54 68 65 6D 65 53 6F 6E 67 2D 4A 61 6D 65 73 42 6F 6E 64 2E 6D 70 33

//TTFis> CD Testfile CD:/mnt/cdrom/Mix/ThemeSong-JamesBond.mp3
// 0F FF 02 C8 00 01 3C 2F 64 16 03 43 44 3A 2F 6D 6E 74 2F 63 64 72 6F 6D 2F 4D 69 78 2F 54 68 65 6D 65 53 6F 6E 67 2D 4A 61 6D 65 73 42 6F 6E 64 2E 6D 70 33

//TTFis> CD Testfile CD:/Kalimba.mp3
// 0F FF 02 C8 00 01 3C 2F 64 16 03 43 44 3a 2f 4b 61 6c 69 6d 62 61 2e 6d 70 33

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlCompressedAudioTitle.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
//#define DATA_LENGTH 2

#define STRING_BEGINNING 0

//------------------------------------------------------------------------------

dia_IOCtrlCompressedAudioTitle::dia_IOCtrlCompressedAudioTitle ( void )
   : dia_IOCtrlSignalRestrictedToRemoteControl (
         DIA_C_U16_DID_RBCM_COMPRESSED_AUDIO_SELECT_TITLE,
         DIA_EN_IOCTRL_SIGTYPE_AUDIO_SELECT_COMPRESSED_AUDIO_TITLE
   )
{
   mAudioSource = DIA_EN_COMP_AUDIO_SOURCE_UNKNOWN;
}

//------------------------------------------------------------------------------

dia_IOCtrlCompressedAudioTitle::~dia_IOCtrlCompressedAudioTitle ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_ICompressedAudioListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlCompressedAudioTitle::~dia_IOCtrlCompressedAudioTitle !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlCompressedAudioTitle::checkPayloadCorrectness( tU16 /*realLength*/, std::vector<tU8>* paylValue ){
   dia_tclFnctTrace oTrace("dia_IOCtrlCompressedAudioTitle::checkPayloadCorrectness(tU8,vector<tU8>*)");
   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("dia_IOCtrlCompressedAudioTitle::checkPayloadCorrectness execute payload check.");

   // Copy vector URI to string for OSAL check
   std::string uri_s = "";
   for(tU8 i=0; i<paylValue->size(); i++){
      uri_s.push_back(paylValue->at(i));
   }
   DIA_TR_INF("path: %s ." , uri_s.c_str());

//   tCString file = uri;

   /* all possible paths
    * ------------------
    * // CD direct
    * "/mnt/cdrom/..."
    * "file:///mnt/cdrom/..."
    * => set Type=CD + relative path
    * // CD indirect
    * "CD:/mnt/cdrom/..."
    * "CD:file:///mnt/cdrom/..."
    * => Identify "CD:" and call CD direct
    *
    * // SD direct
    * "/mnt/sd/..."
    * "file:///mnt/sd/..."
    * => set Type=SD + relative path
    * // SD indirect
    * "SD:/mnt/sd/..."
    * "SD:file:///mnt/sd/..."
    * => Identify "SD:" and call SD direct
    *
    * // USB direct
    * "/mnt/usb/..."
    * "file:///mnt/usb/..."
    * => set Type=USB + relative path
    * // USB indirect
    * "USB:/mnt/usb/..."
    * "USB:file:///mnt/usb/..."
    * => Identify "USB:" and call USB direct
    *
    * + same combinations for new source types
    */

   std::vector<std::pair<std::string, dia_eCompAudioSource> > vecPredefs;
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("/mnt/cdrom",             DIA_EN_COMP_AUDIO_SOURCE_CD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("file:///mnt/cdrom",      DIA_EN_COMP_AUDIO_SOURCE_CD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("CD:/mnt/cdrom",          DIA_EN_COMP_AUDIO_SOURCE_CD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("CD:file:///mnt/cdrom",   DIA_EN_COMP_AUDIO_SOURCE_CD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("CD:",                    DIA_EN_COMP_AUDIO_SOURCE_CD));

   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("/mnt/sd",                DIA_EN_COMP_AUDIO_SOURCE_SD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("file:///mnt/sd",         DIA_EN_COMP_AUDIO_SOURCE_SD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("SD:/mnt/sd",             DIA_EN_COMP_AUDIO_SOURCE_SD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("SD:file:///mnt/sd",      DIA_EN_COMP_AUDIO_SOURCE_SD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("SD:",                    DIA_EN_COMP_AUDIO_SOURCE_SD));

   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("/mnt/usb",               DIA_EN_COMP_AUDIO_SOURCE_USB));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("file:///mnt/usb",        DIA_EN_COMP_AUDIO_SOURCE_USB));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("USB:/mnt/usb",           DIA_EN_COMP_AUDIO_SOURCE_USB));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("USB:file:///mnt/usb",    DIA_EN_COMP_AUDIO_SOURCE_USB));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("USB:",                   DIA_EN_COMP_AUDIO_SOURCE_USB));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("file:///dev/usbms",      DIA_EN_COMP_AUDIO_SOURCE_USB));

   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("/mnt/ipod",              DIA_EN_COMP_AUDIO_SOURCE_IPOD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("file:///mnt/ipod",       DIA_EN_COMP_AUDIO_SOURCE_IPOD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("IPOD:/mnt/ipod",         DIA_EN_COMP_AUDIO_SOURCE_IPOD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("IPOD:file:///mnt/ipod",  DIA_EN_COMP_AUDIO_SOURCE_IPOD));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("IPOD:",                  DIA_EN_COMP_AUDIO_SOURCE_IPOD));

   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("/mnt/bt",                DIA_EN_COMP_AUDIO_SOURCE_BLUETOOTH));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("file:///mnt/bt",         DIA_EN_COMP_AUDIO_SOURCE_BLUETOOTH));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("BT:/mnt/bt",             DIA_EN_COMP_AUDIO_SOURCE_BLUETOOTH));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("BT:file:///mnt/bt",      DIA_EN_COMP_AUDIO_SOURCE_BLUETOOTH));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("BT:",                    DIA_EN_COMP_AUDIO_SOURCE_BLUETOOTH));

   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("/mnt/iphone",               DIA_EN_COMP_AUDIO_SOURCE_IPHONE));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("file:///mnt/iphone",        DIA_EN_COMP_AUDIO_SOURCE_IPHONE));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("IPHONE:/mnt/iphone",        DIA_EN_COMP_AUDIO_SOURCE_IPHONE));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("IPHONE:file:///mnt/iphone", DIA_EN_COMP_AUDIO_SOURCE_IPHONE));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("IPHONE:",                   DIA_EN_COMP_AUDIO_SOURCE_IPHONE));

   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("/mnt/mtp",               DIA_EN_COMP_AUDIO_SOURCE_MTP));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("file:///mnt/mtp",        DIA_EN_COMP_AUDIO_SOURCE_MTP));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("MTP:/mnt/mtp",           DIA_EN_COMP_AUDIO_SOURCE_MTP));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("MTP:file:///mnt/mtp",    DIA_EN_COMP_AUDIO_SOURCE_MTP));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("MTP:",                   DIA_EN_COMP_AUDIO_SOURCE_MTP));

   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("/mnt/flash",             DIA_EN_COMP_AUDIO_SOURCE_FLASH));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("file:///mnt/flash",      DIA_EN_COMP_AUDIO_SOURCE_FLASH));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("FLASH:/mnt/flash",       DIA_EN_COMP_AUDIO_SOURCE_FLASH));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("FLASH:file:///mnt/flash",DIA_EN_COMP_AUDIO_SOURCE_FLASH));
   vecPredefs.push_back(std::pair<std::string, dia_eCompAudioSource>("FLASH:",                 DIA_EN_COMP_AUDIO_SOURCE_FLASH));

   DIA_TR_INF("dia_IOCtrlCompressedAudioTitle:: ----------------------------------------------------------------------");
   for (tU8 i = 0; i < vecPredefs.size(); i++) {
      if (uri_s.find(vecPredefs.at(i).first) == STRING_BEGINNING) {
         DIA_TR_INF("dia_IOCtrlCompressedAudioTitle:: found \"%s\"" , vecPredefs.at(i).first.c_str());
         paylValue->erase(paylValue->begin(), paylValue->begin() + (tU16)vecPredefs.at(i).first.size());
         mAudioSource = vecPredefs.at(i).second;
         retCode = DIA_SUCCESS;
         break;
      } else {
         DIA_TR_INF("dia_IOCtrlCompressedAudioTitle:: NOT found \"%s\"" , vecPredefs.at(i).first.c_str());
      }
   }
   if (mAudioSource == DIA_EN_COMP_AUDIO_SOURCE_UNKNOWN) {
      DIA_TR_ERR("dia_IOCtrlCompressedAudioTitle::checkPayloadCorrectness No String match found.");
      DIA_TR_ERR("dia_IOCtrlCompressedAudioTitle::checkPayloadCorrectness - UNKNOWN MEDIA TYPE!");
   }

   DIA_TR_INF("dia_IOCtrlCompressedAudioTitle:: ----------------------------------------------------------------------");

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlCompressedAudioTitle::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlCompressedAudioTitle::handleRequest(tU8,vector<tU8>*)");
   tBool errorDetected = TRUE;

   if(ctrlValue->size()==0x00){
      DIA_TR_INF("dia_IOCtrlCompressedAudioTitle::handleRequest - vector is emtpy!");
      return DIA_E_CONDITIONS_NOT_CORRECT;
   }

   DIA_TR_INF("dia_IOCtrlCompressedAudioTitle::handleRequest: start Handling.");
   dia_ICompressedAudio* pInterface = 0;
   if ( querySysAdapterInterface<dia_ICompressedAudio>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {

         (void) setSysAdapterListener<dia_ICompressedAudioListener>(this);
         if ( pInterface->selectTrack(mAudioSource, ctrlValue) == DIA_SUCCESS )
         {
            DIA_TR_INF("dia_IOCtrlCompressedAudioTitle::handleRequest - selectTrack DIA_SUCCESS.");
            errorDetected = FALSE;
         }
      } else {
         DIA_TR_INF("dia_IOCtrlCompressedAudioTitle::handleRequest - pInterface failed .");
      }

   } else {
      DIA_TR_INF("dia_IOCtrlCompressedAudioTitle::handleRequest - querySysAdapterInterface failed.");
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_ICompressedAudioListener>(this);
      DIA_TR_ERR("dia_IOCtrlCompressedAudioTitle --- SEND TO COMPRESSED AUDIO SA FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlCompressedAudioTitle::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlCompressedAudioTitle::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_ICompressedAudio* pInterface = 0;
      if ( querySysAdapterInterface<dia_ICompressedAudio>(&pInterface) == DIA_SUCCESS )
      {
         if ( pInterface )
         {
            (void) setSysAdapterListener<dia_ICompressedAudioListener>(this);
            if ( pInterface->selectTrack(mAudioSource, 0) != DIA_SUCCESS )
            {
               DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SELECTAUDIOTRACK !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlCompressedAudioTitle::vOnSelectTrackResult ( tDiaResult success ){
   dia_tclFnctTrace trc("dia_IOCtrlCompressedAudioTitle::vOnSelectTrackResult");

   (void) unsetSysAdapterListener<dia_ICompressedAudioListener>(this);
   if (success == DIA_SUCCESS) {
      DIA_TR_INF("dia_IOCtrlCompressedAudioTitle::vOnSelectTrackResult SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlCompressedAudioTitle::vOnSelectTrackResult DIA_FAILED !!!");
   }

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   // reset last reading
   mAudioSource = DIA_EN_COMP_AUDIO_SOURCE_UNKNOWN;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlCompressedAudioTitle::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlCompressedAudioTitle::handleTimeout");
   (void) unsetSysAdapterListener<dia_ICompressedAudioListener>(this);
}


