/*
 * dia_IOCtrlCDResetLine.h
 *
 *  Created on: 28.01.2013
 *      Author: shw2abt
 */

#ifndef DIA_IOCTRLCDRESETLINE_H_
#define DIA_IOCTRLCDRESETLINE_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

// no further connection to any SAFeature, so we need no interface connection

#define GPIOSTATUSLEVEL_OFF (tU8)0x00
#define GPIOSTATUSLEVEL_ON  (tU8)0x01
#define PAYLOAD_LEN 1

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlCDResetLine
   : public dia_IOCtrlSignal
     // no further connection to any SAFeature, so we need no interface connection
{
public:
   //! class constructor
   dia_IOCtrlCDResetLine ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrlCDResetLine ( tVoid );

   //! handle freeze request
   virtual tDiaResult handleFreeze ( tVoid );
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual tVoid handleTimeout ( tVoid );

   //! Signal to inform requester about the new GPIOStatus
   virtual tVoid vOnSetGPIOStatus ( tU8 status );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! method used to set the corresponding GPIO pin
   tDiaResult setGpioCDResetLine ( tU8 value ) const;


protected:
   //! frozen value used to restore pin status in case of return control to ECU
   tU8 mGpioStatusCDResetLine;
};


#endif /* DIA_IOCTRLCDRESETLINE_H_ */
