/*
 * dia_IOCtrlCDModeControl.h
 *
 *  Created on: 08.08.2012
 *      Author: shw2abt
 */

#ifndef DIA_IOCTRLCDMODECONTROL_H_
#define DIA_IOCTRLCDMODECONTROL_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignalRestrictedToRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VD_MMGR_LISTENER__
#include "common/interfaces/dia_IVDMMGRListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DEVICE_MANAGER_LISTENER__
#include "common/interfaces/dia_IDeviceMGRListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

#define SWITCH2CDDA     1
#define SWITCH2CDROM    2

class dia_IOCtrlCDModeControl
   : public dia_IOCtrlSignalRestrictedToRemoteControl,
     public dia_IVDMMGRListenerImpl,
     public dia_IDeviceMGRListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlCDModeControl( tVoid );
   //! class destructor
   virtual ~dia_IOCtrlCDModeControl( tVoid );

   virtual tDiaResult handleRequest( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual tVoid handleTimeout( tVoid );

   //! Signal to inform requester about success of the CD mode change request
   virtual tVoid vOnCDModeChangeResultMMgr( tDiaResult status );
   virtual tVoid vOnCDModeChangeResultDVM ( tDiaResult status );

private:
   dia_IVDMMGR*      m_pInterfaceMMgr;
   dia_IDeviceMGR*   m_pInterfaceDVM;
   tU8               m_Switch2;

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
};

#endif /* DIA_IOCTRLCDMODECONTROL_H_ */
