/*
 * dia_IOCtrlBtModuleReset.cpp
 *
 *  Created on: 27.10.2015
 *      Author: sbr5kor
//TTFis:> DIA_REQ UDS 07 2F 63 62 03 01
 *                                  (01..FF) -> Reset BT/Wifi
 *                                  (00)     -> Normal
 *      ---------------------------------------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *      28.12.2015  bsu9kor		Added Header Guards and new header files
 *		28.12.2015  bsu9kor		Added code snippet to access GPIO Pin 36 (AIVI-15299)
 *		28.12.2015  bsu9kor		Added code modification to handle return control to ECU (AIVI-15299)
 *      ---------------------------------------------------------------------------------------------------------------------
 */
#ifndef DIA_IOCTRL_BT_MODULE_RESET_H_
#include "common/services/uds/production/dia_IOCtrlBtModuleReset.h"
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"
#endif


#include <unistd.h> //lint !e451 !e537 repeatedly included header file without standard include guard

#define CTRL_VALUE_SIZE 1
#define DATA_LENGTH 3

#define BT_MODULE_STATUS_RESET   0x00
#define BT_MODULE_STATUS_NORMAL  0x01
#define BT_MODULE_STATUS_UNKNOWN 0xFF

#ifdef __ENABLE_BTMODULE_OSAL_DEFINE__
#define DIA_PROP_GPIO_BT_MODULE_RESET_SIZE 0x01
#endif
//------------------------------------------------------------------------------

dia_IOCtrlBtModuleReset::dia_IOCtrlBtModuleReset ( void )
   : dia_IOCtrlSignal (
		 "dia_IOCtrlBtModuleReset",
		 DIA_C_U16_DID_RBCM_BT_MODULE_RESET,
		 CTRL_VALUE_SIZE // Length in Byte
        )
{
}
//------------------------------------------------------------------------------

dia_IOCtrlBtModuleReset::~dia_IOCtrlBtModuleReset ( void )
{
}
//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlBtModuleReset::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlBtModuleReset::handleRequest()");
   tU8 resetStatus = BT_MODULE_STATUS_NORMAL;
   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("dia_IOCtrlBtModuleReset::handleRequest ctrlValue->size() = %zu .", ctrlValue->size());

   switch(ctrlValue->at(0)){
      case 0x00:
    	  resetStatus = BT_MODULE_STATUS_NORMAL;
          DIA_TR_INF("dia_IOCtrlBtModuleReset::handleRequest resetStatus 0x%02x.", ctrlValue->at(0));
          break;
      case 0x01:
    	  resetStatus = BT_MODULE_STATUS_RESET;
          DIA_TR_INF("dia_IOCtrlBtModuleReset::handleRequest resetStatus 0x%02x.", ctrlValue->at(0));
          break;
      default:
    	  DIA_TR_INF("dia_IOCtrlBtModuleReset::handleRequest default resetStatus 0x%02x !", ctrlValue->at(0));
    	  resetStatus = BT_MODULE_STATUS_UNKNOWN;
          break;
   }
   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);
   mIsResultReady = FALSE;

   if (resetStatus != BT_MODULE_STATUS_UNKNOWN)
   {
	   // Reset BT
	   if (resetBTModule (resetStatus) == DIA_SUCCESS)
	   {
		   mIsResultReady = TRUE;
		   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
	   }
	   else
	   {
		   retCode = DIA_FAILED;
	   }
   }
   else
   {
	   DIA_TR_INF("dia_IOCtrlBtModuleReset::handleRequest default resetStatus BT_MODULE_STATUS_UNKNOWN");
	   retCode = DIA_FAILED;
   }

   // NO_ERROR allows the service handler to return immediately
   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlBtModuleReset::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlBtModuleReset::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( (status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      {
    	  DIA_TR_INF("dia_IOCtrlBtModuleReset::vOnTerminate(): Waiting for response");
         // we have to wait for the response
         mIsResultReady = FALSE;
         status = DIA_EN_IOCTRL_STATUS_INACTIVE;
      }
      // Reset BT/Wifi to normal
      if (resetBTModule (BT_MODULE_STATUS_NORMAL) == DIA_SUCCESS)
      {
    	  mIsResultReady = TRUE;
    	  DIA_TR_INF("dia_IOCtrlBtModuleReset::vOnTerminate(): Response received");
    	  DIA_TR_INF("dia_IOCtrlBtModuleReset::vOnTerminate(): ABLE TO WRITE GPIO data");
      }
      else
      {
    	  retCode = DIA_E_ERROR;
    	  DIA_TR_INF("dia_IOCtrlBtModuleReset::vOnTerminate(): UNABLE TO WRITE GPIO data");
    	  setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      }

   }
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
   // this ioctrl is controlled by the external tester
   eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}
//-----------------------------------------------------------------------------

void
dia_IOCtrlBtModuleReset::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlBtModuleReset::handleTimeout");
}
//-----------------------------------------------------------------------------

tDiaResult
dia_IOCtrlBtModuleReset::resetBTModule ( const tU8 ctrlValue ) const
{
	tDiaResult retCode = DIA_FAILED;
#if defined(__ENABLE_BTMODULE_SYS_PATH__)
   dia_tclFnctTrace trc("dia_IOCtrlBtModuleReset::resetBTModule");

   	FILE *fd;
   	tU16 error_code = 0;

   	DIA_TR_INF("Performing reset cycle of the Bluetooth chip...");

   	DIA_TR_INF("enabling the GPIO reset line");

   	fd = fopen("/sys/class/gpio/export", "wb");

   	if (fd == NULL) {
   		error_code = 1;
   		DIA_TR_INF("Reset cycle failed with code: %d", error_code);
   		return retCode;
   	}

   	fwrite("36", sizeof(char), 3, fd);

   	fclose(fd);

   	DIA_TR_INF("setting GPIO direction to output");

   	fd = fopen("/sys/class/gpio/gpio36/direction", "wb");

   	if (fd == NULL) {
   		error_code = 2;
   		DIA_TR_INF("Reset cycle failed with code: %d", error_code);
   		return retCode;
   	}

   	fwrite("out", sizeof(char), 3, fd);

   	fclose(fd);

   	fd = fopen("/sys/class/gpio/gpio36/value", "wb");

   	if (fd == NULL) {
   	   error_code = 3;
   	   DIA_TR_INF("Reset cycle failed with code: %d", error_code);
   	   return retCode;
   	}
   	if(ctrlValue == BT_MODULE_STATUS_RESET){
   		DIA_TR_INF("setting GPIO reset line to LOW for Reset");
   		retCode = DIA_SUCCESS;
   		DIA_TR_INF("RESETTING BT MODULE");
   		fwrite("0", sizeof(char), 1, fd);
   	}
   	else if (ctrlValue == BT_MODULE_STATUS_NORMAL){
   		DIA_TR_INF("setting GPIO reset line to HIGH for Normal");
   		retCode = DIA_SUCCESS;
   		DIA_TR_INF("UNRESETTING BT MODULE");
		fwrite("1", sizeof(char), 1, fd);
   	}
   	else{
   		DIA_TR_INF("Setting GPIO reset Line failed");
   	}
   	fclose(fd);

   	DIA_TR_INF("keep reset High for 100ms then performs usal intialization by doing one more reset");
   	usleep(100000); // DiagOmitSleepWarning

#elif defined(__ENABLE_BTMODULE_OSAL_DEFINE__)
   	dia_tclFnctTrace trc("dia_IOCtrlBtModuleReset::resetBTModule");

   retCode = DIA_SUCCESS;
   tU16 size = dia_getPropertySize(DIA_PROP_GPIO_BT_MODULE_RESET);
   tU8 data[DIA_PROP_GPIO_BT_MODULE_RESET_SIZE] = {0};

   data[OSAL_NULL] = ctrlValue;

   // write System Amp On Output
   if (DIA_SUCCESS != dia_setProperty(DIA_PROP_GPIO_BT_MODULE_RESET, data, size))
   {
	   retCode = DIA_FAILED;
	   DIA_TR_INF("dia_IOCtrlBtModuleReset::resetBTModule(): UNABLE TO WRITE GPIO data");
   }
#else
    DIA_PARAMETER_INTENTIONALLY_UNUSED(ctrlValue);
#endif
   return retCode;
}

