/**
 * \file      dia_IOCtrlBluetoothModuleReset.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      12.10.2012
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */


#ifndef __INCLUDED_DIA_IOCTRL_BLUETOOTH_MODULE_RESET__
#define __INCLUDED_DIA_IOCTRL_BLUETOOTH_MODULE_RESET__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_BLUETOOTHMODULERESETFSM__
#include "common/framework/fsm/generated/dia_BluetoothModuleResetFSM.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#include "common/interfaces/dia_IBluetoothListener.h"
#endif

#define DIA_C_U32_TIMEOUT_BT_MODULE_RESET          ((tU32) 40000)

//-----------------------------------------------------------------------------

class dia_IOCtrlBluetoothModuleReset
   : public dia_IOCtrlSignal,
     public dia_IBluetoothListenerImpl,
     protected dia_BluetoothModuleResetFSM::FsmBehaviour
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_IOCtrlBluetoothModuleReset);

public:
   //! class constructor
   dia_IOCtrlBluetoothModuleReset ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrlBluetoothModuleReset ( tVoid );

   // initial initialization of the FSM
   virtual tVoid vInit ( tVoid );

   //! perform the iocontrol adjustment
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //! timeout has been elapsed
   virtual tVoid handleTimeout ( tVoid );

   //! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( tVoid ) const { return DIA_C_U32_TIMEOUT_BT_MODULE_RESET; }


   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IBluetoothListener methods
   //
   //-------------------------------------------------------------------------

   //! notification of the current BT mode
   virtual tVoid vOnBTModeStatus ( dia_eBTMode mode );
//   //! notification that the BT mode request was accepted by phone component
//   virtual tVoid vOnBTModeRequestACK ( tBool result );
//   //! notification of BT action result
//   virtual tVoid vOnBTTestActionStatus ( dia_eBTAction action );
//   //! notification that the BT action request was accepted by phone component
//   virtual tVoid vOnBTTestActionRequestACK ( tBool result );

protected:
   //! helper used to return control to ECU
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_BluetoothModeFSM::FsmBehaviour methods
   //
   //-------------------------------------------------------------------------

   // FSM actions
   virtual void vFsmSendNegativeResponse ( void* pArg );
   virtual void vFsmSetError_ConditionsNotCorrect ( void* pArg );
   virtual void vFsmRegisterNotifications ( void* pArg );
   virtual void vFsmUnregisterNotifications ( void* pArg );
   virtual void vFsmRequestModuleReset ( void* pArg );
   virtual void vFsmSetError_Sequence ( void* pArg );
   virtual void vFsmSendPositiveResponse ( void* pArg );

   // FSM guards
   virtual bool bIsProductionModeActive ( void* pArg );
   virtual bool bIsNormalModeActivate ( void* pArg );

   //
   // helper methods
   //

//   //! send the request for the given mode to the phone component
//   void vSendModeRequest ( dia_eBTMode mode );
//   //! send the given test tone request to the phone component
//   void vSendTestActionRequest ( dia_eBTAction action );

private:
    //! interface pointer used to interact with the BT module
    dia_IBluetooth* mpBTInterface;

    //! currently activated test mode
    static dia_eBTMode mCurrentMode;
//    //! current state of the test tone = enabled/disabled
//    static tBool mIsI2STestToneActive;
//    //! current state of the local loopback = enabled/disabled
//    static tBool mIsLocalLoopbackActive;

//    //! stores the requested BT mode
//    dia_eBTMode mRequestedMode;
//    //! ACK for the requested BT mode
//    tBool mModeRequestACK;
//
//    //! stores the requested test tone action
//    dia_eBTAction mRequestedAction;
//    //! ACK for the requested BT mode
//    tBool mActionRequestACK;
//
//    //! flag to indicate that we are registered to get mode status updates
//    tBool mIsRegisteredForModeStatus;
//    //! Flag to indicate that we are registered to get test tone status updates
//    tBool mIsRegisteredForTestToneStatus;

    //! error code
    tDiaResult mErrorCode;

//    //! store the result of send operation
//    tDiaResult mSendResult;

    //! pointer to the FSM
    dia_BluetoothModuleResetFSM::Fsm* mpBTResetFSM;

};


#endif /* __INCLUDED_DIA_IOCTRL_BLUETOOTH_MODULE_RESET__ */

