/**
 * \file      dia_IOCtrlBluetoothMode.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      12.10.2012
 *
 * \copyright Robert Bosch Car Multimedia 2012
 *
 * --------------------------------------------------------
 * Date 	       | Author	          | Modification
 * 13.06.14        | GPU2KOR          | Updated BT mode set.
 *************************************************************************/

#ifndef __INCLUDED_DIA_IOCTRL_BLUETOOTH_MODE__
#include "common/services/uds/production/dia_IOCtrlBluetoothMode.h"
#endif

#define DIA_C_U8_BT_MODE_NORMAL                  ((tU8) 0x00)
#define DIA_C_U8_BT_MODE_TEST_LOOPBACK           ((tU8) 0x01)
#define DIA_C_U8_BT_MODE_TEST_LOOPBACK_LOCAL     ((tU8) 0x02)
#define DIA_C_U8_BT_MODE_TEST_I2S                ((tU8) 0x03)

//------------------------------------------------------------------------------

dia_IOCtrlBluetoothMode::dia_IOCtrlBluetoothMode ( tVoid )
   : dia_IOCtrlSignal (
         DIA_C_U16_DID_RBCM_BLUETOOTH_MODE,
         DIA_EN_IOCTRL_SIGTYPE_BLUETOOTH_MODE,
         DIA_EN_IOCTRL_CTRLMODE_ECU
     )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlBluetoothMode::dia_IOCtrlBluetoothMode()");
}

//------------------------------------------------------------------------------

dia_IOCtrlBluetoothMode::~dia_IOCtrlBluetoothMode ( tVoid )
{}

//------------------------------------------------------------------------------

tVoid
dia_IOCtrlBluetoothMode::vInit ( tVoid )
{}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlBluetoothMode::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlBluetoothMode::handleRequest()");

   tU8 bluetoothMode = ctrlValue->at(0);

   switch ( bluetoothMode )
   {
   case DIA_C_U8_BT_MODE_NORMAL:
      DIA_TR_INF( "Bluetooth Test Mode: \"NORMAL\"");
      break;

   case DIA_C_U8_BT_MODE_TEST_LOOPBACK:
      DIA_TR_INF( "Bluetooth Test Mode: \"LOOPBACK\"");
      break;

   default:
      DIA_TR_INF( "Unknown Testmode %d", bluetoothMode);
      return DIA_E_OUT_OF_RANGE;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = TRUE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlBluetoothMode::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlBluetoothMode::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;
   
   mIsResultReady = TRUE;

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlBluetoothMode::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlBluetoothMode::handleTimeout");
}
