/*
 * dia_IOCtrlAudioTestTone.cpp
 *
 *  Created on: 03.08.2012
 *      Author: shw2abt
 */
//TTFis:> DIA_REQ UDS 0A 2F 64 12 03 F1 F2 F3 F4 99

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#include "common/services/uds/production/dia_IOCtrlAudioTestTone.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
//#define DATA_LENGTH 7

//------------------------------------------------------------------------------

dia_IOCtrlAudioTestTone::dia_IOCtrlAudioTestTone(void) :
      dia_IOCtrlSignal(
         DIA_C_U16_DID_RBCM_AUDIO_TEST_TONE,
         DIA_EN_IOCTRL_SIGTYPE_AUDIO_TESTTONE,
         5 // Length in Byte
      )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlAudioTestTone::~dia_IOCtrlAudioTestTone(void)
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IAudioListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlAudioTestTone::~dia_IOCtrlAudioTestTone !!!");
      DIA_ASSERT_ALWAYS();
   }
_BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioTestTone::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioTestTone::handleRequest()");
   tBool errorDetected = TRUE;

   tU32 frequency = U8_2_U32(ctrlValue->at(0),ctrlValue->at(1),ctrlValue->at(2),ctrlValue->at(3)); //lint !e864 Info: expression possibly depends on order of evaluation
   tU8 volume = ctrlValue->at(4);

   dia_IAudio* pInterface = 0;
   if (querySysAdapterInterface<dia_IAudio>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (void) setSysAdapterListener<dia_IAudioListener>(this);
         if (pInterface->setAudioTestToneDBV(frequency, volume, DIA_AUDIO_CHANNEL_MASK_ALL) == DIA_SUCCESS) {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_IAudioListener>(this);
      DIA_TR_ERR("dia_IOCtrlAudioTestTone ---  SEND TO AUDIO SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioTestTone::vOnTerminate(dia_eIOCtrlStatus status)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioTestTone::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_IAudio* pInterface = 0;
      if (querySysAdapterInterface<dia_IAudio>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (void) setSysAdapterListener<dia_IAudioListener>(this);
            if (pInterface->setAudioTestToneMute(DIA_EN_AUDIO_VOLUME_TYPE_DBV) != DIA_SUCCESS) {
               DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SUBSTATE !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlAudioTestTone::vOnTestTone(tDiaResult success)
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioTestTone::vOnTestTone");
   if (success == DIA_SUCCESS) {
      (void) unsetSysAdapterListener<dia_IAudioListener>(this);
      mIsResultReady = TRUE;
      dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
   } else {
      DIA_TR_ERR("dia_IOCtrlAudioTestTone::vOnTestTone NEGATIVE RESULT FROM SA!!!");
   }
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlAudioTestTone::handleTimeout(void)
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioTestTone::handleTimeout");
   (void) unsetSysAdapterListener<dia_IAudioListener>(this);
}
