/*
 * dia_IOCtrlAudioSourceSet.cpp
 *
 *  Created on: 30.11.2012
 *      Author: gib2hi
 *
 --------------------------------------------------------------------------------------
 */

#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifdef __DIA_NEW_AUDIO_SOURCE_SWITCHING_FSM__

#include "dia_IOCtrlAudioSourceSet.h"

#define DIA_C_U8_AUDIO_SOURCE_ID_MAX   ((tU8) 0x1A /* value from PD-CDD for DIA_EN_AUDIO_SOURCE_ENTERTAIN_DTV */)

//------------------------------------------------------------------------------

dia_IOCtrlAudioSourceSet::dia_IOCtrlAudioSourceSet ( void )
   : dia_IOCtrlSignalRestrictedToRemoteControl(DIA_C_U16_DID_RBCM_AUDIO_SOURCE_ACTIVE,DIA_EN_IOCTRL_SIGTYPE_AUDIO_SOURCE,1),
     mRequestedAudioSource(DIA_EN_AUDIO_SOURCE_UNKNOWN) //,
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioSourceSet::dia_IOCtrlAudioSourceSet ( void )");
}

//------------------------------------------------------------------------------

dia_IOCtrlAudioSourceSet::~dia_IOCtrlAudioSourceSet ( void )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioSourceSet::~dia_IOCtrlAudioSourceSet ( void )");
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioSourceSet::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioSourceSet::handleRequest()");

   mErrorInfo = validateCtrlValue(ctrlValue);
   if ( mErrorInfo != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_IOCtrlAudioSourceSet --- ERROR DETECTED (mErrorInfo = 0x%08x) !!!", mErrorInfo);
      return mErrorInfo;
   }

   getInstanceOfAudioManager()->setAudioSource(mRequestedAudioSource,*this);

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioSourceSet::validateCtrlValue ( const std::vector<tU8>* pCtrlValue )
{
   if ( (!pCtrlValue) || (pCtrlValue->size() != 1) ) return DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;

   tU8 srcID = pCtrlValue->at(0);

   std::map<tU8,dia::AudioSourceMatcher>& audioSourceMappers = dia::AudioManager::getSourceMappings();
   std::map<tU8,dia::AudioSourceMatcher>::iterator iter = audioSourceMappers.find(srcID);
   DIA_TR_INF("sources mapped size %zu source ID %u",audioSourceMappers.size(),iter->second.mSrcID);
   if ( (iter == audioSourceMappers.end()) || (iter->second.mSrcID == DIA_EN_AUDIO_SOURCE_UNKNOWN) )
   {
      if (iter == audioSourceMappers.end()) DIA_TR_INF("dia_IOCtrlAudioSourceSet::validateCtrlValue: srcID=0x%02X not found.", srcID);
      else if (iter->second.mSrcID == DIA_EN_AUDIO_SOURCE_UNKNOWN)    DIA_TR_INF("dia_IOCtrlAudioSourceSet::validateCtrlValue: second.mSrcID=0x%02X unknown.", iter->second.mSrcID);
      return DIA_E_CONDITIONS_NOT_CORRECT;
   }

   mRequestedAudioSource = iter->second.mSrcID;

   DIA_TR_INF("dia_IOCtrlAudioSourceSet::validateCtrlValue: set audio source %s (0x%02x, CDD=0x%02x)", iter->second.mNamePattern.c_str(), mRequestedAudioSource, srcID);
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioSourceSet::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioSourceSet::vOnTerminate()");

   getInstanceOfAudioManager()->resetClient();

   // we must not wait for a response
   mIsResultReady = TRUE;

   // this ioctrl is no longer active
   eSetStatus(status);

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlAudioSourceSet::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioSourceSet::handleTimeout");
   getInstanceOfAudioManager()->resetClient();
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlAudioSourceSet::onAudioSourceSetResult ( dia_eAudioSource sourceID, tDiaResult resultCode )
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioSourceSet::vFsmSendResponse");

   if ( sourceID != mRequestedAudioSource ) return;

   setErrorInfo(resultCode);
   getInstanceOfAudioManager()->resetClient();
   mIsResultReady = TRUE;

   DIA_TR_INF("dia_IOCtrlAudioSourceSet::onAudioSourceSetResult (%s) !!!", (mErrorInfo == DIA_SUCCESS) ? "SUCCESSFUL" : "DIA_FAILED");

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

#else

#include "dia_IOCtrlAudioSourceSet.h"

//------------------------------------------------------------------------------

dia_IOCtrlAudioSourceSet::dia_IOCtrlAudioSourceSet ( void )
   : dia_IOCtrlSignalRestrictedToRemoteControl (
         DIA_C_U16_DID_RBCM_AUDIO_SOURCE_ACTIVE,
         DIA_EN_IOCTRL_SIGTYPE_AUDIO_SOURCE,
         1 // Payload Length
         )
{
   mAudSource      = DIA_EN_AUDIO_SOURCE_UNKNOWN;
   mAudSourceID    = dia_tAudioSourceType();
   mAudSourceReady = FALSE;
   mAudSink        = DIA_EN_AUDIO_SINK_AMPLIFIER_MAINFIELD;
   mAudSinkID      = dia_tAudioSinkType();
   mAudSinkReady   = FALSE;
}

//------------------------------------------------------------------------------

dia_IOCtrlAudioSourceSet::~dia_IOCtrlAudioSourceSet ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IAudioSourceListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlAudioGain::~dia_IOCtrlAudioGain !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioSourceSet::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioSourceSet::handleRequest()");
   tBool errorDetected = TRUE;

   tU8 srcID = ctrlValue->at(0);
   DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest set to Source = 0x%02x", srcID);

   /**********************************
    * MATCH CDD IDs TO INTERNAL ENUM *
    **********************************/

   switch(srcID)
   {
      case 0x00:  // AM
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x00 -> TUNER_AM .");
         mAudSource = DIA_EN_AUDIO_SOURCE_TUNER_AM;
         break;
      case 0x01:  // FM
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x00 -> TUNER_FM .");
         mAudSource = DIA_EN_AUDIO_SOURCE_TUNER_FM;
         break;
      case 0x02:  // reserved 2
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x is not used - reserved.", srcID);
         break;
      case 0x03:  // DAB
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> TUNER_DAB .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_TUNER_DAB;
         break;
      case 0x04:  // XM
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> TUNER_XM .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_TUNER_XM;
         break;
      case 0x05:  // HD Radio
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x not supported .", srcID);
         break;
      case 0x06:  // reserved
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x is not used - reserved.", srcID);
         break;
      case 0x07:  // MIC 1
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> MICROPHONE .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_MICROPHONE;
         break;
      case 0x08:  // reserved
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x is not used - reserved.", srcID);
         break;
      case 0x09:  // ZAudio
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> MEDIA_PLAYER .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_MEDIA_PLAYER;
         break;
      case 0x0A:  // CD
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> CDDA .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_MEDIA_CDDA;
         break;
      case 0x0B:  // DVD
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x not supported .", srcID);
         break;
      case 0x0C:  // DCM
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> DCM .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_DCM;
         break;
      case 0x0D:  // RSE
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x not supported .", srcID);
         break;
      case 0x0E:  // AUX 1
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> AUX_1 .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_AUX_1;
         break;
      case 0x0F:  // AUX 2
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> AUX_2 .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_AUX_2;
         break;
      case 0x10:  // PHONE
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> PHONE .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_PHONE;
         break;
      case 0x11:  // PHONE BT Audio
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> PHONE_BTAUDIO .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_PHONE_BTAUDIO;
         break;
      case 0x12:  // TA DAB
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> TA_DAB .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_TUNER_TA_DAB;
         break;
      case 0x13:  // TA FM
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> TA_FM .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_TUNER_TA_FM;
         break;
      case 0x14:  // Navi Speech
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> NAVI_SPEECH .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_NAVI_SPEECH;
         break;
	  case 0x15:  // DRM
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> TUNER_DRM .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_TUNER_DRM;
         break;
	  case 0x16:  // PHONE ECALL
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> PHONE_ECALL .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_PHONE_ECALL;
         break;
	  case 0x17:  // MICROPHONE2
	     DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> MICROPHONE2 .", srcID);
	     mAudSource = DIA_EN_AUDIO_SOURCE_MICROPHONE2;
	     break;
     case 0x18:  /* value from PD-CDD (CMAudioSource) */
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> EXT_CD .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_ENTERTAIN_EXT_CD;
         break;
     case 0x19:  /* value from PD-CDD (CMAudioSource) */
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::handleRequest => case 0x%02x -> SPARE_CD .", srcID);
         mAudSource = DIA_EN_AUDIO_SOURCE_ENTERTAIN_SPARE_CD;
         break;
      default:
         DIA_TR_ERR("dia_IOCtrlAudioSourceSet::handleRequest => UNKNOWN SOURCE ID 0x%02x !", srcID);
         break;
   }

   /***************************************************
    * COLLECT VARIABLE INFORMATION FOR SOURCE SETTING *
    ***************************************************/

   if (mAudSource != DIA_EN_AUDIO_SOURCE_UNKNOWN) {
      dia_IAudioSource* pInterface = 0;
      if ((querySysAdapterInterface<dia_IAudioSource>(&pInterface) == DIA_SUCCESS) && pInterface) {
         (void) setSysAdapterListener<dia_IAudioSourceListener>(this);
         if (pInterface->getAudioSourceList() == DIA_SUCCESS) {
            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_IOCtrlAudioSourceSet::handleRequest => Error: getAudioSourceList failed !");
         }
         if (errorDetected==FALSE && pInterface->getAudioSinkList() == DIA_SUCCESS) {
//            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_IOCtrlAudioSourceSet::handleRequest => Error: getAudioSinkList failed !");
         }
      } else {
         DIA_TR_ERR("dia_IOCtrlAudioSourceSet::handleRequest => Error: Cannot get dia_IAudioSource !");
      }
   } else {
      DIA_TR_ERR("dia_IOCtrlAudioSourceSet::handleRequest => Error: Source unknown !");
      // Sending back the Negative answer
      (void) unsetSysAdapterListener<dia_IAudioSourceListener>(this);
      mIsResultReady = TRUE;
      setErrorInfo(DIA_E_SUBFUNCTION_NOT_SUPPORTED);
      dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
      return DIA_FAILED;
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IAudioSourceListener>(this);
      DIA_TR_ERR("dia_IOCtrlAudioSourceSet --- SEND TO AUDIO MANAGER FAILED !!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void
dia_IOCtrlAudioSourceSet::sendSetSourceWhenReady() {
   dia_tclFnctTrace trc("dia_IOCtrlAudioSourceSet::sendSetSourceWhenReady");

   // Check with ==TRUE is important and has to be here (shw2abt)
   if ( (mAudSourceReady==TRUE) && (mAudSinkReady==TRUE) )
   {
      DIA_TR_INF("dia_IOCtrlAudioSourceSet::sendSetSourceWhenReady DATA Complete.");

      if (mAudSource != DIA_EN_AUDIO_SOURCE_UNKNOWN && mAudSink != DIA_EN_AUDIO_SINK_UNKNOWN) {
         dia_IAudioSource* pInterface = 0;
         if ((querySysAdapterInterface<dia_IAudioSource>(&pInterface) == DIA_SUCCESS) && pInterface) {
            (void) setSysAdapterListener<dia_IAudioSourceListener>(this);
            if (pInterface->setAudioSource(mAudSourceID.mSourceID,mAudSinkID.mSinkID) == DIA_SUCCESS) {
               // -
            } else {
               DIA_TR_ERR("dia_IOCtrlAudioSourceSet::handleRequest => Error: setAudioSource failed !");
            }
         } else {
            DIA_TR_ERR("dia_IOCtrlAudioSourceSet::handleRequest => Error: Cannot get dia_IAudioSource !");
         }
      }
   } else if ( mAudSourceReady == FALSE && mAudSinkReady == FALSE ){
      DIA_TR_ERR("dia_IOCtrlAudioSourceSet::sendSetSourceWhenReady FAIL");
      // Sending back the Negative answer
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
   } else {
      if (mAudSourceReady == FALSE) {
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::sendSetSourceWhenReady audio source NOT READY.");
      } else {
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::sendSetSourceWhenReady audio source ID = %d Enum = %d.", mAudSourceID.mSourceID, mAudSource);
      }
      if (mAudSinkReady == FALSE) {
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::sendSetSourceWhenReady audio sink NOT READY.");
      } else {
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::sendSetSourceWhenReady audio sink ID = %d Enum = %d.", mAudSinkID.mSinkID, mAudSink);
      }
      DIA_TR_INF("dia_IOCtrlAudioSourceSet::sendSetSourceWhenReady => NOT READY.");
   }
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioSourceSet::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioSourceSet::vOnTerminate()");

   // we must not wait for a response
   mIsResultReady = TRUE;

   // this ioctrl is no longer active
   eSetStatus(status);

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlAudioSourceSet::vOnAudioSourceList ( const std::vector<dia_tAudioSourceType>& audioSrcList )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioSourceSet::vOnAudioSourceList");
   DIA_TR_INF("dia_IOCtrlAudioSourceSet::vOnAudioSourceList search sourceEnum 0x%02x .", mAudSource);

   for(tU8 i=0; i<audioSrcList.size() && mAudSourceReady==FALSE; i++){
      DIA_TR_INF("dia_IOCtrlAudioSourceSet::vOnAudioSourceList check sourceEnum 0x%02x with devID 0x%02x .", audioSrcList.at(i).mSourceEnum, audioSrcList.at(i).mSourceID);
      if(audioSrcList.at(i).mSourceEnum==mAudSource){
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::vOnAudioSourceList found sourceEnum 0x%02x with devID 0x%02x .", audioSrcList.at(i).mSourceEnum, audioSrcList.at(i).mSourceID);
         mAudSourceID = audioSrcList.at(i);
         mAudSourceReady = TRUE;
      }
   }

   sendSetSourceWhenReady();
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlAudioSourceSet::vOnAudioSinkList ( const std::vector<dia_tAudioSinkType>& audioSinkList )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioSourceSet::vOnAudioSinkList");

   for(tU8 i=0; i<audioSinkList.size() && mAudSinkReady==FALSE; i++){
      DIA_TR_INF("dia_IOCtrlAudioSourceSet::vOnAudioSinkList check sink 0x%02x with ID 0x%02x .", audioSinkList.at(i).mSinkEnum, audioSinkList.at(i).mSinkID);
      if(audioSinkList.at(i).mSinkEnum==mAudSink){
         DIA_TR_INF("dia_IOCtrlAudioSourceSet::vOnAudioSinkList found sink 0x%02x with ID 0x%02x .", audioSinkList.at(i).mSinkEnum, audioSinkList.at(i).mSinkID);
         mAudSinkID = audioSinkList.at(i);
         mAudSinkReady = TRUE;
      }
   }

   sendSetSourceWhenReady();
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlAudioSourceSet::vOnAudioSourceConnectionDone ( tDiaResult res )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioSourceSet::vOnAudioSourceConnectionDone");

   (void) unsetSysAdapterListener<dia_IAudioSourceListener>(this);
   mIsResultReady = TRUE;
   if( res == DIA_SUCCESS ) {
      DIA_TR_INF("dia_IOCtrlAudioSourceSet::vOnAudioSourceConnectionDone SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlAudioSourceSet::vOnAudioSourceConnectionDone DIA_FAILED !!!");
   }

   // Reset values
   mAudSource      = DIA_EN_AUDIO_SOURCE_UNKNOWN;
   mAudSourceID    = dia_tAudioSourceType();
   mAudSourceReady = FALSE;
   mAudSink        = DIA_EN_AUDIO_SINK_AMPLIFIER_MAINFIELD;
   mAudSinkID      = dia_tAudioSinkType();
   mAudSinkReady   = FALSE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlAudioSourceSet::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioSourceSet::handleTimeout");
   (void) unsetSysAdapterListener<dia_IAudioSourceListener>(this);
}

#endif
