/*!
 * \file       dia_IOCtrlAudioSinkSet.h
 *
 * \brief      IOCtrl used to chang the audio sink
 *
 * \details    IOCtrl used to chang the audio sink
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2011-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_IOCTRL_AUDIO_SINK_SET__
#define __INCLUDED_DIA_IOCTRL_AUDIO_SINK_SET__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#include <common/framework/protocols/uds/ioctrl/dia_IOCtrlSignalRestrictedToRemoteControl.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_SINK_LISTENER__
#include "common/interfaces/dia_IAudioSinkListener.h"
#endif

namespace dia {

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class IOCtrlAudioSinkSet
   : public dia_IOCtrlSignalRestrictedToRemoteControl,
     public dia_IAudioSinkListenerImpl
{
public:
   //! class constructor
   IOCtrlAudioSinkSet ( void );
   //! class destructor
   virtual ~IOCtrlAudioSinkSet ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //!
   virtual void handleTimeout ( void );

   //! response to setAudioSink
   virtual void onAudioSinkSet ( tDiaResult success );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

protected:
   //
};

}

#endif /* __INCLUDED_DIA_IOCTRL_AUDIO_SINK_SET__ */
