/*
 * dia_IOCtrlAudioLinearMode.h
 *
 *  Created on: 02.08.2012
 *      Author: shw2abt
 */
/*
 * The system shall implement a diagnostic service IOControl audioLinearMode to provide the diagnostic tester the ability to control the status of the audio linear mode.
 * If the audio linear mode has been activated, the system shall set all sound processing measures or parameters to a linear or fixed specified value. The linear mode shall
 * be implemented in a way that it is suitable as reference for production tests.
 */

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIOCONTROL_LISTENER__
#include "common/interfaces/dia_IAudioControlListener.h"
#endif

#ifndef DIA_IOCONTROLAUDIOLINEARMODE_H_
#define DIA_IOCONTROLAUDIOLINEARMODE_H_

#define AUDIOLINEARMODE_ENABLED  0x01
#define AUDIOLINEARMODE_DISABLED 0x00

class dia_IOCtrlAudioLinearMode
	: public dia_IOCtrlSignal,
	  public dia_IAudioControlListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlAudioLinearMode ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrlAudioLinearMode ( tVoid );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //!
   virtual tVoid handleTimeout ( tVoid );

   //! respone to dia_setAudioLinearMode
   virtual tVoid vOnAudioLinearMode ( tDiaResult success );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

};


#endif /* dia_IOCtrlAudioLinearMode_H_ */
