/*
 * dia_IOCtrlAudioLinearMode.cpp
 *
 *  Created on: 03.08.2012
 *      Author: shw2abt
 */
// TTFis: DIA_REQ UDS 06 2F 64 15 03 00/01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlAudioLinearMode.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
//#define DATA_LENGTH 7

//------------------------------------------------------------------------------

dia_IOCtrlAudioLinearMode::dia_IOCtrlAudioLinearMode ( tVoid )
	: dia_IOCtrlSignal (
	      DIA_C_U16_DID_RBCM_AUDIO_LINEAR_MODE,
	      DIA_EN_IOCTRL_SIGTYPE_AUDIO_LINEARMODE,
	      1 // , Length
	  )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlAudioLinearMode::~dia_IOCtrlAudioLinearMode ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IAudioControlListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlAudioLinearMode::~dia_IOCtrlAudioLinearMode !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioLinearMode::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
	dia_tclFnctTrace oTrace("dia_IOCtrlAudioLinearMode::handleRequest()");
   tBool errorDetected = TRUE;

   dia_IAudioControl* pInterface = 0;
   if (querySysAdapterInterface<dia_IAudioControl>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_IAudioControlListener>(this);

         tU8 mode = ctrlValue->at(0);
         if ( mode == AUDIOLINEARMODE_DISABLED || mode == AUDIOLINEARMODE_ENABLED ) {
            if (pInterface->dia_setAudioLinearMode(mode) == DIA_SUCCESS) {
               errorDetected = FALSE;
            }
         } else {
            DIA_TR_ERR("dia_IOCtrlAudioLinearMode::handleRequest LINEAR MODE has invalid value (0x%02x)!",mode);
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_IAudioControlListener>(this);
      DIA_TR_ERR("dia_IOCtrlAudioLinearMode ---  SEND TO AUDIO SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);
   mIsResultReady = FALSE;

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioLinearMode::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioLinearMode::vOnTerminate()");
   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_IAudioControl* pInterface = 0;
      if (querySysAdapterInterface<dia_IAudioControl>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (tVoid) setSysAdapterListener<dia_IAudioControlListener>(this);
            if (pInterface->dia_setAudioLinearMode(AUDIOLINEARMODE_DISABLED) != DIA_SUCCESS) {
               DIA_TR_ERR("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SELECT AUDIO LINEAR MODE !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlAudioLinearMode::vOnAudioLinearMode ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioLinearMode::vOnDiagnosisActivity");

   (tVoid) unsetSysAdapterListener<dia_IAudioControlListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("DIA_IOCTRLAUDIOLINEARMODE::vOnAudioLinearMode SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);              // set error condition which is checked by the super class
      DIA_TR_ERR("DIA_IOCTRLAUDIOLINEARMODE::vOnAudioLinearMode DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlAudioLinearMode::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioLinearMode::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IAudioControlListener>(this);
}

