/*
 * dia_IOCtrlAudioGain.h
 *
 *  Created on: 26.07.2012
 *      Author: shw2abt
 */
/*
 * The system shall implement a diagnostic service IOControl audioGain to provide the diagnostic tester the ability to control the audio Gain.
 * If the IOControl is active, the system shall inhibit any other influence on the audioGain except influences to avoid hardware damages.
 * This IOControl shall only be accepted if the IOControl  remoteControl is currently active.
 */
// TTFis: DIA_REQ UDS 06 2F 64 11 03 45

#ifndef DIA_IOCTRL_AUDIOGAIN_H_
#define DIA_IOCTRL_AUDIOGAIN_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignalRestrictedToRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIOCONTROL_LISTENER__
#include "common/interfaces/dia_IAudioControlListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlAudioGain
   : public dia_IOCtrlSignalRestrictedToRemoteControl,
     public dia_IAudioControlListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlAudioGain ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrlAudioGain ( tVoid );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //!
   virtual tVoid handleTimeout ( tVoid );

   //! respone to setAudioGain
   virtual tVoid vOnAudioGain ( tDiaResult success );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

protected:
   //
};

#endif /* DIA_IOCTRL_AUDIOGAIN_H_ */
