/*
 * dia_IOCtrlAudioGain.cpp
 *
 *  Created on: 26.07.2012
 *      Author: shw2abt
 */
// TTFis: DIA_REQ UDS 06 2F 64 11 03 45

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlAudioGain.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
//#define DATA_LENGTH 1

//------------------------------------------------------------------------------

dia_IOCtrlAudioGain::dia_IOCtrlAudioGain ( tVoid )
   : dia_IOCtrlSignalRestrictedToRemoteControl (
         DIA_C_U16_DID_RBCM_AUDIO_GAIN,
         DIA_EN_IOCTRL_SIGTYPE_AUDIO_VOLUME,
         1 // Payload Length
   )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlAudioGain::~dia_IOCtrlAudioGain ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IAudioControlListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlAudioGain::~dia_IOCtrlAudioGain !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioGain::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioGain::handleRequest()");

   tBool errorDetected = TRUE;

   tU8 gainRaw = ctrlValue->at(0);

   /* possible range: 0x80 ... 0xFF 0x00 */
   /* invalid range:  0x01 ... 0x7F */
   if(!(gainRaw>0x00 && gainRaw<0x80)){
   dia_IAudioControl* pInterface = 0;
      if ((querySysAdapterInterface<dia_IAudioControl>(&pInterface) == DIA_SUCCESS) && pInterface) {
      (tVoid) setSysAdapterListener<dia_IAudioControlListener>(this);

         if (pInterface->dia_setAudioGain(gainRaw) == DIA_SUCCESS) {
         errorDetected = FALSE;
      }
   }
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IAudioControlListener>(this);
      DIA_TR_ERR("dia_IOCtrlAudioGain --- SEND TO AUDIO SERVER FAILED!!!!");
      if(gainRaw>0x00 && gainRaw<0x80){
         DIA_TR_ERR("dia_IOCtrlAudioGain::handleRequest audio gain = 0x%02x IS INVALID!", gainRaw);
         return DIA_E_OUT_OF_RANGE;
      } else {
      return DIA_FAILED;
   }
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioGain::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioGain::vOnTerminate()");
   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_IAudioControl* pInterface = 0;
      if (querySysAdapterInterface<dia_IAudioControl>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (tVoid) setSysAdapterListener<dia_IAudioControlListener>(this);
            if (pInterface->dia_setAudioGain(0x00) != DIA_SUCCESS) {
               DIA_TR_ERR("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SELECT AUDIO GAIN !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}


//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlAudioGain::vOnAudioGain ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioGain::vOnDiagnosisActivity");
   
   (tVoid) unsetSysAdapterListener<dia_IAudioControlListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlAudioGain::vOnDiagnosisActivity SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlAudioGain::vOnDiagnosisActivity DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlAudioGain::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioGain::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IAudioControlListener>(this);
}
