/*
 * dia_IOCtrlAudioBalance.cpp
 *
 *  Created on: 24.10.2012
 *      Author: shw2abt
 *--------------------------------------------------------------------------------
 * Date				|	User ID		|	Modification
 * 27/5/2016		|	bma9kor		|	Audio balance functions facilitate Diaglib communication  (CMG3G-10183)
 *--------------------------------------------------------------------------------
 */
// TTFis: DIA_REQ UDS 06 2F 64 13 03 06

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlAudioBalance.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
//#define DATA_LENGTH 2

//------------------------------------------------------------------------------

dia_IOCtrlAudioBalance::dia_IOCtrlAudioBalance(tVoid) :
   dia_IOCtrlSignalRestrictedToRemoteControl (
         DIA_C_U16_DID_RBCM_AUDIO_BALANCE,
         DIA_EN_IOCTRL_SIGTYPE_AUDIO_BALANCE,
         1 /* Payload Length */
   )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlAudioBalance::~dia_IOCtrlAudioBalance(tVoid)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IAudioBalFaderListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlAudioBalance::~dia_IOCtrlAudioBalance !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

 //------------------------------------------------------------------------------

//lint -e715 shw2abt: timerValue is not used in this context
tDiaResult
dia_IOCtrlAudioBalance::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioBalance::handleRequest(tU8,vector<tU8>*)");
   tBool errorDetected = TRUE;

   DIA_TR_INF("dia_IOCtrlAudioBalance::handleRequest: start Handling.");
   dia_IAudioBalFader* pInterface = 0;
   if (querySysAdapterInterface<dia_IAudioBalFader>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_IAudioBalFaderListener>(this);
         tS8 balance = (tS8) ctrlValue->at(0);
         if ( balance > -10 && balance < 10 ) {
            if (pInterface->dia_setAudioBalance(balance) == DIA_SUCCESS) {
               errorDetected = FALSE;
            }
         } else {
            DIA_TR_ERR("dia_IOCtrlAudioFader::handleRequest BALANCE has invalid value (%d)!",balance);
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_IAudioBalFaderListener>(this);
      DIA_TR_ERR("dia_IOCtrlAudioFader ---  SEND TO AUDIO SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}
//lint +e715

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioBalance::vOnTerminate(dia_eIOCtrlStatus status)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioBalance::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_IAudioBalFader* pInterface = 0;
      if (querySysAdapterInterface<dia_IAudioBalFader>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (tVoid) setSysAdapterListener<dia_IAudioBalFaderListener>(this);
            if (pInterface->dia_setAudioBalance(0x00) != DIA_SUCCESS) {
               DIA_TR_ERR("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SELECT AUDIO BALANCE !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlAudioBalance::vOnAudioBalance ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioBalance::vOnAudioBalance");
   
   (tVoid) unsetSysAdapterListener<dia_IAudioBalFaderListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlAudioBalance::vOnAudioBalance SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlAudioBalance::vOnAudioBalance DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlAudioBalance::handleTimeout(tVoid)
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioBalance::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IAudioBalFaderListener>(this);
}
