/*
 * dia_IOCtrlActiveVideoSource.h
 *
 *  Created on: 06.08.2012
 *      Author: shw2abt
 */
/*
 * The system shall implement a diagnostic service IOControl activeVideoSource to provide the diagnostic tester
 * the ability to select the active video source of the display (e.g. rear view camera).
 *      --------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *      01.12.2015  bsu9kor		Added activateVideoSource function to set video source
 *
 *
 *      ---------------------------------------------------------------------------------------
 */
// TTFis:\> DIA_REQ UDS 06 2F	00 42 11 22

#ifndef DIA_IOCTRLACTIVEVIDEOSOURCE_H_
#define DIA_IOCTRLACTIVEVIDEOSOURCE_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VIDEOSOURCE_LISTENER__
#include "common/interfaces/dia_IVideoSourceListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlActiveVideoSource
	: public dia_IOCtrlSignal,
	  public dia_IVideoSourceListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlActiveVideoSource ( void );
   //! class destructor
   virtual ~dia_IOCtrlActiveVideoSource ( void );

//   virtual tDiaResult handleRequest ( tU8 timerValue, tU8 ctrlValue );
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual void handleTimeout ( void );

   //! acknowledge that the diagnosis activity substate was entered
   virtual void vOnSubstateAck ( void );

   //! Signal to inform requester about success of the active video source selection
   virtual void vOnVideoSourceSelect ( tDiaResult success );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! Set Video Source information
   tDiaResult activateVideoSource ( const dia_VideoSrcInfo& rVideoInfo ) const;
};

#endif /* DIA_IOCTRLACTIVEVIDEOSOURCE_H_ */
