/*
 * dia_IOCtrlActiveVideoSource.cpp
 *
 *  Created on: 06.08.2012
 *      Author: shw2abt
 *      --------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *      01.12.2015  bsu9kor		Added activateVideoSource function to set video source
 *      08.01.2016	bsu9kor		Corrected return control to ECU bug.
 *
 *      ---------------------------------------------------------------------------------------
 */
// TTFis:\> DIA_REQ UDS 06 2F 62 01 03 01/02

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef DIA_IOCTRLACTIVEVIDEOSOURCE_H_
#include "common/services/uds/production/dia_IOCtrlActiveVideoSource.h"
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"
#endif

//------------------------------------------------------------------------------

dia_IOCtrlActiveVideoSource::dia_IOCtrlActiveVideoSource ( void )
   : dia_IOCtrlSignal (
         DIA_C_U16_DID_RBCM_ACTIVE_VIDEO_SOURCE,
         DIA_EN_IOCTRL_SIGTYPE_ACTIVE_VIDEO_SOURCE,
         1
     )
{}

//------------------------------------------------------------------------------

dia_IOCtrlActiveVideoSource::~dia_IOCtrlActiveVideoSource ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IVideoSourceListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlActiveVideoSource::~dia_IOCtrlActiveVideoSource !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlActiveVideoSource::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlActiveVideoSource::handleRequest()");

   tBool errorDetected = TRUE;

         for(tU8 i=0; i<ctrlValue->size(); i++){
           DIA_TR_INF("dia_IOCtrlActiveVideoSource::handleRequest ctrlValue->at(%d)=0x%02x",i,ctrlValue->at(i) );
         }

         dia_VideoSrcInfo videoSrcInfo(DIA_EN_VIDEOSRC_UNKNOWN,DIA_EN_VIDEONORM_UNKNOWN);
         if(ctrlValue->at(0) == 0x01         /*normal hmi*/){
            videoSrcInfo.videoSrc = DIA_EN_VIDEOSRC_INT;
         } else if(ctrlValue->at(0) == 0x02  /*rear view camera*/){
            videoSrcInfo.videoSrc = DIA_EN_VIDEOSRC_EXT;
         } else {
#ifndef __DIA_UNIT_TESTING__
            DIA_TR_ERR("dia_IOCtrlActiveVideoSource::handleRequest - UNKNOWN PAYLOAD BYTE 0x%02x !!!!",ctrlValue->at(0) );
#endif
            return DIA_FAILED;
         }
#ifndef __DIA_UNIT_TESTING__
         DIA_TR_INF("dia_IOCtrlActiveVideoSource::handleRequest - activeVideoSource: 0x%02x Norm 0x%02x.",videoSrcInfo.videoSrc,videoSrcInfo.videoNorm);
#endif
         (void) setSysAdapterListener<dia_IVideoSourceListener>(this);
         if ( activateVideoSource(videoSrcInfo) == DIA_SUCCESS )
         {
             DIA_TR_INF("dia_IOCtrlActiveVideoSource::handleRequest - setVideoSource SUCCESSFUL");
             errorDetected = FALSE;
         }
         else
         {
             DIA_TR_INF("dia_IOCtrlActiveVideoSource::handleRequest - setVideoSource FAILED");
         }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IVideoSourceListener>(this);
      DIA_TR_ERR(" ---  SEND TO VIDEOSOURCE SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlActiveVideoSource::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlActiveVideoSource::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }
      dia_VideoSrcInfo videoSrcInfo(DIA_EN_VIDEOSRC_INT,DIA_EN_VIDEONORM_UNKNOWN);
      if ( activateVideoSource(videoSrcInfo) == DIA_SUCCESS )
      {
    	  mIsResultReady = TRUE;
    	  DIA_TR_INF("dia_IOCtrlActiveVideoSource::vOnTerminate SUCCESSFUL !!!");
      }
      else
      {
    	  DIA_TR_INF("dia_IOCtrlActiveVideoSource::vOnTerminate SUCCESSFUL !!!");
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlActiveVideoSource::vOnSubstateAck ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlActiveVideoSource::vOnSubstateAck");

   (void) unsetSysAdapterListener<dia_IVideoSourceListener>(this);
   mIsResultReady = TRUE;
#ifndef __DIA_UNIT_TESTING__
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
#endif
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlActiveVideoSource::vOnVideoSourceSelect ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlActiveVideoSource::vOnVideoSourceSelect");
   
   (void) unsetSysAdapterListener<dia_IVideoSourceListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlActiveVideoSource::vOnVideoSourceSelect SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlActiveVideoSource::vOnVideoSourceSelect DIA_FAILED !!!");
   }

#ifndef __DIA_UNIT_TESTING__
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
#endif
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlActiveVideoSource::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlActiveVideoSource::handleTimeout");
   (void) unsetSysAdapterListener<dia_IVideoSourceListener>(this);
}
//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    activateVideoSource
*
* DESCRIPTION: Calls the system adapter functinality to activate the requested video source
*
* PARAMETER:   const dia_VideoSrcInfo& rVideoInfo - structure containing the videosource type and mode
*
* RETURNVALUE: SUCCESSFUL  - video source successfully activated
*              FALSE - video source activation failed
*
******************************************************************************/
tDiaResult
dia_IOCtrlActiveVideoSource::activateVideoSource ( const dia_VideoSrcInfo& rVideoInfo ) const
{
	tDiaResult retCode = DIA_FAILED;
	   dia_IVideoSource* pInterface = 0;
	   if ( querySysAdapterInterface<dia_IVideoSource>(&pInterface) == DIA_SUCCESS )
	   {
	      if ( pInterface )
	      {
	         if ( pInterface->setVideoSource(rVideoInfo) == DIA_SUCCESS )
	         {
	            DIA_TR_INF("dia_IOCtrlActiveVideoSource::activateVideoSource -  SUCCESSFUL");
	            retCode = DIA_SUCCESS;
	         } else {
	            DIA_TR_INF("dia_IOCtrlActiveVideoSource::activateVideoSource -  FAILED");
	         }
	      }
	   }
	   return retCode;
}

