/*
 * dia_IOCtrlADR3SetSignalQuality.cpp
 *
 *  Created on: 27.07.2012
 *      Author:
 */
// TTFis:\> DIA_REQ UDS 00 2F 60 0D 03

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_IOCtrlADR3SetSignalQuality.h"

#define DATA_START 3
#define DATA_LENGTH 2

//-----------------------------------------------------------------------------

dia_IOCtrlADR3SetSignalQuality::dia_IOCtrlADR3SetSignalQuality ( void )
    : dia_ServiceHandlerUDS("dia_IOCtrlADR3SetSignalQuality",DIA_C_U8_UDS_SID_IOCONTROL_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_ADR3_SET_SIGNAL_QUALITY /*DID*/)
{
   dia_tclFnctTrace trc("dia_IOCtrlADR3SetSignalQuality::dia_IOCtrlADR3SetSignalQuality(tVoid)");
}

//-----------------------------------------------------------------------------

dia_IOCtrlADR3SetSignalQuality::~dia_IOCtrlADR3SetSignalQuality ( void )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_IADRListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlADR3SetSignalQuality::~dia_IOCtrlADR3SetSignalQuality !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_IOCtrlADR3SetSignalQuality::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_IOCtrlADR3SetSignalQuality::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IADR* pInterface = 0;
   if ( querySysAdapterInterface<dia_IADR>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         // copy the message buffer except the length info in the first byte
         std::vector<tU8> adrMessage;
         for ( tU16 i=1; i<oDiagMsgBuffer().u16GetDataLength(); i++ )
         {
            adrMessage.push_back(oDiagMsgBuffer().u8GetData(i));
         }

         (tVoid) setSysAdapterListener<dia_IADRListener>(this);
         if ( pInterface->sendADRContainerMessage(adrMessage) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF("dia_IOCtrlADR3SetSignalQuality::vProcessRequest - sendADRContainerMessage() failed.");
         }
      }
   }
   else
   {
      DIA_TR_INF("dia_IOCtrlADR3SetSignalQuality::vProcessRequest - querySysAdapterInterface NOK !");
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IADRListener>(this);
      DIA_TR_ERR("dia_IOCtrlADR3SetSignalQuality ---  SEND TO ADR3 FAILED!!!!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlADR3SetSignalQuality::vOnADRContainerMessageResponse ( std::vector<tU8>& adrResponse )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlADR3SetSignalQuality::vOnADRContainerMessageResponse()");

   (tVoid) unsetSysAdapterListener<dia_IADRListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength((tU16) adrResponse.size());
   for ( tU16 i=0; i < adrResponse.size(); i++ )
   {
      oDiagMsgBuffer().setDataU8(i, adrResponse[i]);
   }
   vResReadyAndQuit();
}

