/**
 * \file    dia_SrvHandlerGenericWIFINameRead.h
 *
 * \brief   This file contains the definition of the dia_SrvHandlerGenericWIFINameRead class,
 *          that provides a generic service handler that can be used to process
 *          wifi name identification requests that require to retrieve a two properties of wifiname1 and wifiname2 from
 *          the ConfigManager.
 *
 * \author  nbs3kor
 * \date    2015/07/06
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_SERVICE_HANDLER_GENERIC_WIFINAME_READ__
#define __INCLUDED_SERVICE_HANDLER_GENERIC_WIFINAME_READ__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif


class dia_SrvHandlerGenericWIFINameRead
    : public dia_ServiceHandlerUDS
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerGenericWIFINameRead);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericWIFINameRead);

public:
   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 1 byte
    *             data identifier
    *
    * \param[in]  name     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (1 byte)
    *
    * \return     none
    */
   dia_SrvHandlerGenericWIFINameRead ( tCString name, tU8 sid, tU16 did );

   /**
    *
    * \brief      class constructor
    *
    *             class constructor with name, service identifier and 2 byte
    *             data identifier
    *
    * \param[in]  did      diagnostic data identifier (2 byte)
    */
   dia_SrvHandlerGenericWIFINameRead ( tU16 did );
   /**
    *
    * \brief      class destructor
    *
    *             class destructor
    */
   virtual ~dia_SrvHandlerGenericWIFINameRead ( void );
   /**
    *
    * \brief      method called to start service processing
    *
    *             This method is used to start processing of a received diagnosis
    *             request. The additional parameters are parameters provided by
    *             the service handler itself during creation of its lookup key. The
    *             lookup key and up to two parameters are stored in the lookup table
    *             of a service dispatcher that dispatches incoming message to the
    *             associated service handler.
    *
    * \param[in]  pArname     name used to distinguish between multiple instances
    * \param[in]  sid      diagnostic service identifier (e.g. 0x22)
    * \param[in]  did      diagnostic data identifier (2 byte)
    *
    * \return     none
    */
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );
};

#endif /* __INCLUDED_SERVICE_HANDLER_GENERIC_WIFINAME_READ__ */
