/*
 * dia_SrvHandlerGenericSessionControl.cpp
 *
 *  Created on: 14.12.2010
 *      Author: gib2hi
 */


#ifndef __INCLUDED_DIA_SESSION_CONTROLLER__
#include <common/framework/application/dia_SessionController.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include <common/framework/engine/dia_EngineServerConfiguration.h>
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEY__
#include <common/framework/engine/dia_LookupKey.h>
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include <common/framework/engine/dia_Session.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#include "dia_SrvHandlerGenericSessionControl.h"

using namespace std;

#define SC_START    ((tU8)  3) // The index where the data segment starts in the DiagMsgBufferUds
#define SC_LENGTH   ((tU8)  0) // The number of bytes in the data part

//------------------------------------------------------------------------------

dia_SrvHandlerGenericSessionControl::dia_SrvHandlerGenericSessionControl ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandlerGenericSessionControl",DIA_C_U8_UDS_SID_SESSION_CONTROL),
     mSessionID(0xFF)
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericSessionControl::dia_SrvHandlerGenericSessionControl()"); //lint !e1788: reviewed by gib2hi
}

//------------------------------------------------------------------------------

dia_SrvHandlerGenericSessionControl::dia_SrvHandlerGenericSessionControl ( tU8 initialSession )
   : dia_ServiceHandlerUDS("dia_SrvHandlerGenericSessionControl",DIA_C_U8_UDS_SID_SESSION_CONTROL),
     mSessionID(initialSession)
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericSessionControl::dia_SrvHandlerGenericSessionControl(tU8)"); //lint !e1788: reviewed by gib2hi
}

//------------------------------------------------------------------------------

dia_SrvHandlerGenericSessionControl::~dia_SrvHandlerGenericSessionControl ( void )
{}

//------------------------------------------------------------------------------

void
dia_SrvHandlerGenericSessionControl::vProcessRequest(const std::vector<tArgsType>& /*vecArgs*/)
{
    dia_tclFnctTrace trc("dia_SrvHandlerGenericSessionControl::vProcessRequest"); // lint !e1788: reviewed by gib2hi

    //  Msg contents:
    //      byte[0] = Number of bytes in message (maybe)
    //      byte[1] = Service ID
    //      byte[2] = diagnosticSessionType

    if (mpEngine)
    {
        // check if we have received the right coding value length
        tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
        if (dataLength != (SC_START + SC_LENGTH))
        {
            vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
            return;
        }

        // session (with removed suppress-positive-response bit --> only VW)
        mSessionID = (oDiagMsgBuffer().u8GetSubServiceId());

        if (mpEngine->isSessionSupported(mSessionID))
        {
            (void)mpEngine->getSessionController()->addListener(this);

            if (mpEngine->setSession(mSessionID) == DIA_SUCCESS)
            {
                // we are done, because the session change was a synchronous operation
                mpEngine->getSessionController()->removeListener(this);

                vector<tU8> results;

                dia_Session* pSession = 0;
                if (mpEngine->querySession(&pSession, mSessionID) == DIA_SUCCESS)
                {
                    if (pSession)
                        pSession->getResponseParameters(results);
                }

                vSendPositiveResponse(static_cast<tU16>(2 /* standard response length e.g. 0x10 0x60 */ + results.size()), &results);
            }
        }
        else
        {
            DIA_TR_INF("SESSION NOT SUPPORTED (ID=0x%0x) !!", mSessionID);
            vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_SUBFUNCTION_NOT_SUPPORTED));
        }
    }
    else
    {
        DIA_TR_ERR("ERROR: Engine not initialized, cannot switch session");
    }
}

//------------------------------------------------------------------------------

tVoid
dia_SrvHandlerGenericSessionControl::vOnSessionChanged ( tU8 newSession, tU8 /*oldSession*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericSessionControl::vOnSessionChanged"); //lint !e1788: reviewed by gib2hi

   mpEngine->getSessionController()->removeListener(this);

   if ( newSession == mSessionID )
   {
      vector<tU8> results;

      dia_Session* pSession = 0;
      if ( mpEngine->querySession(&pSession,mSessionID) == DIA_SUCCESS )
      {
         if ( pSession ) (tVoid) pSession->getResponseParameters(results);
      }

      vSendPositiveResponse( static_cast<tU16>(2 /* standard response length e.g. 0x10 0x60 */ + results.size()), &results);
   }
}

//------------------------------------------------------------------------------

void
dia_SrvHandlerGenericSessionControl::vOnTimeout ( void )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericSessionControl::vOnTimeout");

   dia_SessionController* pSessionCtrl = mpEngine->getSessionController();

   if (pSessionCtrl)
   {
      pSessionCtrl->removeListener(this);
      pSessionCtrl->onSetSessionTimeout();
   }

   //Default handling with NRC
   dia_ServiceHandlerUDS::vOnTimeout();
}

//------------------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericSessionControl::makeLookupKeys ( std::vector<dia_LookupKey*>& keys )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandlerGenericSessionControl::makeLookupKeys"); //lint !e1788: reviewed by gib2hi
#endif

   if ( mLookupKeys.empty() )
   {
      if ( mpEngine )
      {
         const vector<tU8>& supportedSessions = mpEngine->getServerConfiguration().getSessions();

         for ( tU16 i=0; i<supportedSessions.size(); i++ )
         {
            mLookupKeys.push_back( OSAL_NEW dia_LookupKey( 0x10, (tU8) supportedSessions[i], DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) );
         }
      }
   }

   keys = mLookupKeys;

   return DIA_SUCCESS;
}
