/*
 * dia_SrvHandlerGenericSecurityAccess.h
 *
 *  Created on: 10.08.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_SECURITY_ACCESS__
#define __INCLUDED_DIA_SRVHANDLER_GENERIC_SECURITY_ACCESS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include <common/framework/protocols/uds/dia_ServiceHandlerUDS.h>
#endif

class dia_SecurityLevel;

class dia_SrvHandlerGenericSecurityAccess
    : public dia_ServiceHandlerUDS
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_SrvHandlerGenericSecurityAccess);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericSecurityAccess);

public:
   //! process the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );
   //! return the lookup keys for service requests processed by this handler
   virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );
   //! implementation for timeout notifications (initiates negative response 0x22)
   virtual void vOnTimeout ( void );

   static void onSeedResult ( tDiaResult resultCode, const std::vector<tU8>& seedValue, const dia_SecurityLevel& secLevel );
   static void onKeyValidationResult ( tDiaResult resultCode, const dia_SecurityLevel& secLevel );

protected:
   //! initialize processing
   virtual void reset ( void );
   //! validate the data of the security access, e.g. for valid length, seed or key request ...
   virtual tDiaResult validateRequest ( const std::vector<tU8>& data );

protected:
   //! pointer to the active service handler
   static dia_SrvHandlerGenericSecurityAccess* mpInstance;
   //! level identifier
   tU8  mLevelID;
   //! flag to indicate whether a validated request refers to a seed or key request
   bool mIsSeedRequest;
   //! flag to indicate that a seed was requested but the response is pending
   bool mIsWaitingForSeed;
   //! flag to indicate that a key was sent but the validation result is pending
   bool mIsWaitingForKeyValidation;
};

#endif /* __INCLUDED_DIA_SRVHANDLER_GENERIC_SECURITY_ACCESS__ */
