/*
 * dia_SrvHandlerGenericSecurityAccess.cpp
 *
 *  Created on: 10.08.2012
 *      Author: gib2hi
 */


#ifndef __INCLUDED_DIA_COMMON_SECURITY__
#include "common/framework/security/dia_common_security.h"
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_SECURITY_ACCESS__
#include "dia_SrvHandlerGenericSecurityAccess.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEY__
#include "common/framework/engine/dia_LookupKey.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

using namespace std;

#define SA_START_OF_REQUEST         ((tU8)  2) // The index where the data segment starts in the DiagMsgBufferUds
#define SA_LENGTH_OF_SEED_REQUEST   ((tU16) 2)
#define SA_MSG_DATA_OFFSET          ((tU16) 1)

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericSecurityAccess*
dia_SrvHandlerGenericSecurityAccess::mpInstance = 0;

//------------------------------------------------------------------------------

dia_SrvHandlerGenericSecurityAccess::dia_SrvHandlerGenericSecurityAccess ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandlerGenericSecurityAccess",DIA_C_U8_UDS_SID_SECURITY_ACCESS),
     mLevelID(0x00),
     mIsSeedRequest(false),
     mIsWaitingForSeed(false),
     mIsWaitingForKeyValidation(false)
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericSecurityAccess::dia_SrvHandlerGenericSecurityAccess()");
#endif
}

//------------------------------------------------------------------------------

dia_SrvHandlerGenericSecurityAccess::~dia_SrvHandlerGenericSecurityAccess ( void )
{}

//------------------------------------------------------------------------------

void
dia_SrvHandlerGenericSecurityAccess::reset ( void )
{
   mLevelID = 0x00;
   mIsSeedRequest = false;
   mIsWaitingForSeed = false;
   mIsWaitingForKeyValidation = false;

   //! pointer to the active service handler
   mpInstance = this;
}

//------------------------------------------------------------------------------

void
dia_SrvHandlerGenericSecurityAccess::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericSecurityAccess::vOnReqRx");

   //  Msg contents:
   //      byte[0] = Number of bytes in message (maybe)
   //      byte[1] = Service ID
   //      byte[2] = security level

   reset();

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();

   std::vector<tU8> requestData;
   for ( tU16 len = 0; len < (oDiagMsgBuffer().u16GetDataLength()-SA_MSG_DATA_OFFSET); len++ )
   {
      requestData.push_back(pU8[len+SA_MSG_DATA_OFFSET]);
   }

   tDiaResult retCode = validateRequest(requestData);

   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericSecurityAccess: FAILED (DATA VALIDATION) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
      return;
   }

   dia_SecurityManager* pSecMgr = getInstanceOfSecurityManager();
   if ( !pSecMgr )
   {
      DIA_TR_INF("SECURITY MANAGER NOT AVAILABLE !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_GENERAL_PROGRAMMING_FAILURE));
      return;
   }

   tU8 levelID = (mLevelID % 2 ) ? mLevelID : static_cast<tU8>(mLevelID-1);
   dia_SecurityLevel* pLevel = pSecMgr->pGetLevelUDS(levelID);

   if ( !pLevel )
   {
      // the requested level is not supported
      DIA_TR_INF("REQUESTED SECURITY ACCESS LEVEL NOT FOUND !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_SUBFUNCTION_NOT_SUPPORTED));
      return;
   }

   pLevel->initialize();

   if ( mIsSeedRequest )
   {
      // tester is requesting a seed
      DIA_TR_INF("Received Seed request for Level 0x%02x (%s)", mLevelID, pLevel->getName());

      mIsWaitingForSeed = true;

//    vector<tU8> seedValue;
      retCode = pLevel->getSeed(/*seedValue*/);

//      if ( retCode == DIA_SUCCESS )
//      {
//         // seed was successfully generated
//         vSendPositiveResponse((tU16) (seedValue.size()+2),&seedValue);
//      }

      if ( retCode == DIA_E_RESPONSE_PENDING )
      {
         // we are done here, because the seed will be generated asynchronously by external module
         retCode = DIA_SUCCESS;
      }
      else if ( retCode != DIA_SUCCESS)
      {
         DIA_TR_INF("FAILED TO GENERATE SEED !!");
      }
   }
   else
   {
      // tester is sending the key
      DIA_TR_INF("Received Key for Level 0x%02x (%s)", mLevelID, pLevel->getName());

      vector<tU8> keyValue;
      for ( tU16 i=SA_START_OF_REQUEST, j=1; i < requestData.size(); i++,j++ )
      {
         keyValue.push_back(requestData.at(i));
         DIA_TR_INF("Key[%02d]: 0x%02x", j, requestData.at(i) );
      }

      mIsWaitingForKeyValidation = true;

      retCode = pLevel->acceptKey(keyValue);

//      if ( retCode == DIA_SUCCESS )
//      {
//         vSendPositiveResponse(2);
//      }
      if ( retCode == DIA_E_RESPONSE_PENDING )
      {
         // we are done here, because the key will be validated asynchronously by external module
         retCode = DIA_SUCCESS;
      }
      else if ( retCode != DIA_SUCCESS)
      {
         DIA_TR_INF("INVALID SECURITY KEY NOT ACCEPTED !!");
      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_INF("SECURITY ACCESS CURRENTLY NOT SUPPORTED !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
   }
}

//------------------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericSecurityAccess::validateRequest ( const std::vector<tU8>& data )
{
   if ( data.size()  < SA_LENGTH_OF_SEED_REQUEST ) return DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
   mLevelID = data.at(1);
   if ( mLevelID % 2 )
   {
      // Seed request, check request length
      if ( data.size()  != SA_LENGTH_OF_SEED_REQUEST ) return DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
      mIsSeedRequest = true;
   }
   return  DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericSecurityAccess::makeLookupKeys ( std::vector<dia_LookupKey*>& keys )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandlerGenericSecurityAccess::makeLookupKeys");
#endif

   dia_SecurityManager* pSecMgr = getInstanceOfSecurityManager();
   if ( !pSecMgr ) return DIA_FAILED;

   tDiaResult retCode = DIA_SUCCESS;

   if ( mLookupKeys.empty() )
   {
      std::vector<tU16> accessTypes;
      pSecMgr->getAccessTypes(accessTypes);
      if ( accessTypes.size() > 0 )
      {
         for ( std::vector<tU16>::iterator iter = accessTypes.begin(); iter != accessTypes.end(); iter++ )
         {
            mLookupKeys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_SECURITY_ACCESS, (tU8) (*iter), DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) );
         }
      }
      else
      {
         DIA_TR_ERR("##### NO SECURITY LEVELS FOUND #####");
         retCode = DIA_FAILED;
      }
   }

   keys = mLookupKeys;

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerGenericSecurityAccess::onSeedResult ( tDiaResult resultCode, const std::vector<tU8>& seedValue, const dia_SecurityLevel& /*secLevel*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericSecurityAccess::onSeedResult");

   if ( mpInstance && mpInstance->mIsWaitingForSeed )
   {
      if ( resultCode == DIA_SUCCESS )
      {
         mpInstance->vSendPositiveResponse((tU16) (seedValue.size()+2), &(const_cast<std::vector<tU8>&>(seedValue)));
      }
      else
      {
         mpInstance->vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      }

      mpInstance->mIsWaitingForSeed = false;
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerGenericSecurityAccess::onKeyValidationResult ( tDiaResult resultCode, const dia_SecurityLevel& /*secLevel*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericSecurityAccess::onKeyValidationResult");

   if ( mpInstance && mpInstance->mIsWaitingForKeyValidation )
   {
      if ( resultCode == DIA_SUCCESS )
      {
         mpInstance->vSendPositiveResponse(2);
      }
      else
      {
         mpInstance->vSendNegativeResponse(getInstanceOfFactory()->makeNRC(resultCode));
      }

      mpInstance->mIsWaitingForKeyValidation = false;
   }
}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerGenericSecurityAccess::vOnTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericSecurityAccess::vOnTimeout");
   mLevelID = 0x00;
   mIsSeedRequest = false;
   mIsWaitingForSeed = false;
   mIsWaitingForKeyValidation = false;
   mpInstance = 0;
   dia_ServiceHandlerUDS::vOnTimeout();
}

