/*
 * dia_SrvHandlerGenericRoutineCtrl.h
 *
 *  Created on: 21.08.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_ROUTINE_CONTROL__
#define __INCLUDED_DIA_SRVHANDLER_GENERIC_ROUTINE_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ROUTINECONTROL_LISTENER__
#include "common/interfaces/dia_IRoutineControlListener.h"
#endif

class dia_Routine;

//-----------------------------------------------------------------------------

class dia_SrvHandlerGenericRoutineCtrl
   : public dia_ServiceHandlerUDS,
     public dia_IRoutineControlListener
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_SrvHandlerGenericRoutineCtrl);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericRoutineCtrl);

public:
   //! Receives incoming messages and forward them
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );
   //! called when the component response was not delivered in time
   virtual void vOnTimeout ( void );
   //! called to request the lookup keys for this service
   virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );

   //! retrieve the value of the processing timeout
   virtual tU32  getTimeoutValue ( void ) const;

   virtual void vOnRoutineUpdate ( dia_Routine& routine );

protected:
   //! start the given routine
   tDiaResult startRoutine ( dia_Routine& routine );
   //! stop the given routine
   tDiaResult stopRoutine ( dia_Routine& routine );
   //! get result for the given routine
   tDiaResult getRoutineResult ( dia_Routine& routine );

   //! send positive response depending on the control byte 1
   void vSendRoutineCtrlPositiveResponse ( dia_UID uID, std::vector<tU8>& data ) const;
   //! convert subID into signal type
   dia_UID getRoutineID ( tU16 subID ) const;
   //! convert subID into signal type
   tU16 getRoutineUdsID ( dia_UID uID ) const;

   //!
   virtual dia_eRoutineEntryOption  extractEntryOption ( void );
   //! convert subID into signal type
   virtual tU16 extractRoutineID ( void ) const;
   //! returns the start position of the payload
   virtual tU16 getPayloadIndex();

   //! inititialize members if a new request is processed
   void vReset ( void );

protected:
   //! pointer to the remote control object
   dia_IRoutineControl* mpRtCtrlInterface;
   //! routine identifier
   dia_UID mUID;//dia_eRoutineID mID;
   //! entry option
   dia_eRoutineEntryOption  mEntryOption;
   //! routine results vector
   std::vector<tU8> mResults;
   //! start position of input message payload / index for data segment
   tU16 mPayloadIndex;
};

#endif /* __INCLUDED_DIA_SRVHANDLER_GENERIC_ROUTINE_CONTROL__ */
