/*
 * dia_SrvHandlerGenericRequestDownload.cpp
 *
 *  Created on: 13.01.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_GENERIC_SERVICE_HANDLER_REQUEST_DOWNLOAD__
#include "common/services/uds/generic/dia_SrvHandlerGenericRequestDownload.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS_PROJECT__
#include "project/framework/factory/dia_factoryMethodsProject.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_MANAGER__
#include "common/framework/datadownload/dia_DataDownloadManager.h"
#endif

#define MSG_DATA_OFFSET 1

#define DIA_C_U8_REQDNL_BYTEPOS_SRV_ID          ((tU8) 0)
#define DIA_C_U8_REQDNL_BYTEPOS_FMT_ID          ((tU8) 1)
#define DIA_C_U8_REQDNL_BYTEPOS_ADDRFMT_ID      ((tU8) 2)
#define DIA_C_U8_REQDNL_BYTEPOS_STARTADDR       ((tU8) 3)

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericRequestDownload::dia_SrvHandlerGenericRequestDownload ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandlerGenericRequestDownload",DIA_C_U8_UDS_SID_REQUEST_DOWNLOAD )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericRequestDownload::dia_SrvHandlerGenericRequestDownload()");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericRequestDownload::~dia_SrvHandlerGenericRequestDownload ( void )
{}

//----------------------------------------------------------------------

void
dia_SrvHandlerGenericRequestDownload::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericRequestDownload::vProcessRequest");

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();

   std::vector<tU8> requestData;
   for ( tU16 len = 0; len < (oDiagMsgBuffer().u16GetDataLength()-MSG_DATA_OFFSET); len++ )
   {
      requestData.push_back(pU8[len+MSG_DATA_OFFSET]);
   }

   dia_DataDownloadManager* pDnlManager = getInstanceOfDataDownloadManager();
   if ( !pDnlManager )
   {
      // Sending back the Negative answer
      DIA_TR_ERR("dia_SrvHandlerGenericRequestDownload: FAILED (NO ACCESS TO DOWNLOAD MANAGER) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      return;
   }

   if (setSysAdapterListener<dia_IDataDownloadListener>(this) != DIA_SUCCESS)
   {
      DIA_TR_ERR("dia_SrvHandlerGenericRequestDownload: FAILED (NO REG AS LISTENER) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      return;
   }

   tDiaResult retCode = pDnlManager->requestDownload(requestData);
   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_ERR("dia_SrvHandlerGenericRequestDownload: FAILED (DATA DOWNLOAD REQUEST) !!");

      (void) unsetSysAdapterListener<dia_IDataDownloadListener>(this);

      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
   }

   // Wait for update on listener interface
}

//----------------------------------------------------------------------

void
dia_SrvHandlerGenericRequestDownload::vOnRequestDownloadUpdate( std::vector<tU8>& responseData )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericRequestDownload::vOnRequestDownloadUpdate");

   (void) unsetSysAdapterListener<dia_IDataDownloadListener>(this);

   // Sending back the positive answer
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength((tU16) (responseData.size() + 1));
   for ( tU16 j=0; j<((tU16) responseData.size()); ++j )
   {
      (void) oDiagMsgBuffer().vSetDataU8(tU16(j+1), responseData.at(j));
   }

   vResReadyAndQuit();
}
