/*
 * dia_SrvHandlerGenericReadFaultMemory.h
 *
 *  Created on: 26.06.2012
 *      Author: shw2abt
 */

#ifndef DIA_SRVHANDLERGENERICREADFAULTMEMORY_H_
#define DIA_SRVHANDLERGENERICREADFAULTMEMORY_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif

class dia_SrvHandlerGenericReadFaultMemory
    : public dia_ServiceHandlerUDS,
      public dia_IErrorLogListenerImpl
{
    DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerGenericReadFaultMemory);
    DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericReadFaultMemory);

public:
   //! class constructor
    dia_SrvHandlerGenericReadFaultMemory ( const tU8 u8DID );
   //! class destructor
   virtual ~dia_SrvHandlerGenericReadFaultMemory ( void );

   /**
    * \brief      handle the received request
    *
    *					Function recieves the message via the oDiagMsgBuffer and send it to the SA.
    *					A generic fault memory message function sends the message to the correct
    *					subfunction.
    *
    * \param[in]  tVoid*     -
    * \param[in]  tVoid*     -
    */
   virtual tVoid vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   virtual tVoid vOnReadDTCbyStatusMaskResult(const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList);
   virtual tVoid vOnReadNumberOfDTCByStatusMaskResult(const tU8 u8DTCStatusAvailabilityMask, const tU32 u32NumberOfDTC);
   virtual tVoid vOnReadSupportedDTCResult(const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList);
   virtual tVoid vOnReadLastConfirmedDTCResult(const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList);
   virtual tVoid vOnDiaglogGetExtendedDataByDTC(IErrorLogExtendedDataResult const& aExtendedData);
   virtual tVoid vOnDiaglogGetSnapShotDataByDTC ( const tU32 dtc, const tU8 status, std::list<IErrorLogSnapshotDataResult>& snapshotList);
   virtual tVoid vOnDiaglogGetSnapShotId ( std::list<IErrorLogSnapshotIdResult>& snapshotList);
   virtual tVoid vOnError ( const dia_ErrorInfoInterface& errInfo );

   

protected:
   tU8 m_u8StatusMask;
};


#endif /* DIA_SRVHANDLERGENERICREADFAULTMEMORY_H_ */
