/*
 * dia_SrvHandlerGenericReadFaultMemory.cpp
 *
 *  Created on: 26.06.2012
 *      Author: shw2abt
 */
//   TTFis: DIA_REQ UDS 04 19 02 09
// include own class
#include "dia_SrvHandlerGenericReadFaultMemory.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
//#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include <vd_diaglog_if.h>

#ifndef __INCLUDED_DIA_ERROR_INFO_INTERFACE__
#include <common/framework/errmgmt/dia_ErrorInfoInterface.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include <common/framework/config/dia_ConfigManager.h>
#endif

#define RS_START                 ((tU8)    3) // The index where data starts in the DiagMsgBufferUds
#define RS_LENGTH_BY_MASK        ((tU8)    1) // The number of bytes in the data part
#define RS_LENGTH_BY_DTC         ((tU8)    4) // The number of bytes in the data part
#define READ_REQ_BUFFER_SIZE     ((tU8)    7) // Maximum read request buffer size
#define DID_POS                  ((tU8)    2) // DID position in the Message buffer
using namespace dia;
//------------------------------------------------------------------------------

dia_SrvHandlerGenericReadFaultMemory::dia_SrvHandlerGenericReadFaultMemory (tU8 u8DID  )
   : dia_ServiceHandlerUDS("dia_SrvHandlerGenericReadFaultMemory", DIA_C_U8_UDS_SID_READ_DTC_INFO, u8DID),
     m_u8StatusMask(0)
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericReadFaultMemory::dia_SrvHandlerGenericReadFaultMemory()");
}

//------------------------------------------------------------------------------

dia_SrvHandlerGenericReadFaultMemory::~dia_SrvHandlerGenericReadFaultMemory ( tVoid )
{
    _BP_TRY_BEGIN
    {
       (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandlerGenericReadFaultMemory::~dia_SrvHandlerGenericReadFaultMemory !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//------------------------------------------------------------------------------

tVoid
dia_SrvHandlerGenericReadFaultMemory::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericReadFaultMemory::vProcessRequest()");

   dia_IErrorLog* pErrorLog = 0;

   if ( querySysAdapterInterface<dia_IErrorLog>(&pErrorLog) == DIA_SUCCESS && pErrorLog)
   {
      (tVoid) setSysAdapterListener<dia_IErrorLogListener>(this);

      tU8 u8SubId = oDiagMsgBuffer().u8GetData(DID_POS);
      tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();

      switch (u8SubId)
      {
         case UDS_REPORT_NUMBER_OF_DTC_BY_STATUS_MASK:
         {
            if ( dataLength != 4 )
            {
               DIA_TR_INF("UDS_REPORT_NUMBER_OF_DTC_BY_STATUS_MASK: Invalid Length %d<>4",dataLength);
               (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
               vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
            }
            else
            {
               m_u8StatusMask = oDiagMsgBuffer().u8GetData(DID_POS+1);
               tU8 u8Group = DIAGLOG_MEMORY_CUSTOMER;
               if (vecArgs.size() == 1)
               {
                  u8Group = VoidCast<tU8>(vecArgs[0]);
               }

               if(pErrorLog->getNumberOfDTCbyStatusMask(u8Group, m_u8StatusMask) == DIA_SUCCESS)
               {
                  DIA_TR_INF("getNumberOfDTCbyStatusMask: SUCCESS");
               }
               else
               {
                  DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vProcessRequest pErrorLog->getNumberOfDTCbyStatusMask failed");
                  (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
                  vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
               }
            }
            break;
         }// case UDS_REPORT_NUMBER_OF_DTC_BY_STATUS_MASK:

         case UDS_REPORT_DTC_BY_STATUS_MASK:
         {
            if ( dataLength != 4 )
            {
               DIA_TR_INF("UDS_REPORT_DTC_BY_STATUS_MASK: Invalid Length %d<>4",dataLength);
               (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
               vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
            }
            else
            {
               m_u8StatusMask = oDiagMsgBuffer().u8GetData(DID_POS+1);
               tU8 u8Group = DIAGLOG_MEMORY_CUSTOMER;
               if (vecArgs.size() == 1)
               {
                  u8Group = VoidCast<tU8>(vecArgs[0]);
               }

               if(pErrorLog->getDTCbyStatusMask(u8Group, m_u8StatusMask) == DIA_SUCCESS)
               {
                  DIA_TR_INF("getDTCbyStatusMask: SUCCESS");
               }
               else
               {
                  DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vProcessRequest pErrorLog->getDTCbyStatusMask failed");
                  (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
                  vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
               }
            }
            break;
         }// case UDS_REPORT_DTC_BY_STATUS_MASK:

         case UDS_REPORT_DTC_SNAPSHOT_IDENTIFIER:
         {
            if ( dataLength != 3 )
            {
               DIA_TR_INF("UDS_REPORT_DTC_SNAPSHOT_IDENTIFIER: Invalid Length %d<>2",dataLength);
               (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
               vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
            }
            else
            {
               tU8 u8Group = DIAGLOG_MEMORY_CUSTOMER;
               if (vecArgs.size() == 1)
               {
                  u8Group = VoidCast<tU8>(vecArgs[0]);
               }

               if(pErrorLog->getSnapShotId(u8Group) == DIA_SUCCESS)
               {
                  DIA_TR_INF("getDTCbyStatusMask: SUCCESS");
               }
               else
               {
                  DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vProcessRequest pErrorLog->getDTCbyStatusMask failed");
               (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
                  vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
               }
            }
            break;
         }// case UDS_REPORT_DTC_SNAPSHOT_IDENTIFIER:

         case UDS_REPORT_DTC_SNAPSHOT_RECORD_BY_DTC_NUMBER:
         {
            if ( dataLength != 7 )
            {
               DIA_TR_INF("UDS_REPORT_DTC_SNAPSHOT_RECORD_BY_DTC_NUMBER: Invalid Length %d<>6",dataLength);
               (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
               vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
            }
            else
            {
               tU32 dtc = ((tU32)oDiagMsgBuffer().u8GetData(DID_POS+1)<<16) + ((tU32)oDiagMsgBuffer().u8GetData(DID_POS+2)<<8) + (oDiagMsgBuffer().u8GetData(DID_POS+3));
               tU8 u8Group = DIAGLOG_MEMORY_CUSTOMER;
               tU8 RecordNumber = oDiagMsgBuffer().u8GetData(DID_POS+4);
               if (vecArgs.size() == 1)
               {
                  u8Group = VoidCast<tU8>(vecArgs[0]);
               }

               if(pErrorLog->getSnapShotData(u8Group,dtc,RecordNumber) == DIA_SUCCESS)
               {
                  DIA_TR_INF("getDTCbyStatusMask: SUCCESS");
               }
               else
               {
                  DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vProcessRequest pErrorLog->getDTCbyStatusMask failed");
               (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
                  vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
               }
            }
            break;
         }// case UDS_REPORT_DTC_SNAPSHOT_IDENTIFIER:

         case UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER:
         {
            if ( dataLength != 7 )
            {
               DIA_TR_INF("UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER: Invalid Length %d<>7",dataLength);
               (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
               vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
            }
            else
            {
               tU32 dtc = ((tU32)oDiagMsgBuffer().u8GetData(DID_POS+1)<<16) + ((tU32)oDiagMsgBuffer().u8GetData(DID_POS+2)<<8) + (oDiagMsgBuffer().u8GetData(DID_POS+3));
               tU8  recordNumber = oDiagMsgBuffer().u8GetData(DID_POS+4);
               tU8  group = 1;
               if (vecArgs.size() == 1)
               {
                  group = VoidCast<tU8>(vecArgs[0]);
               }

               if(pErrorLog->getExtendedData(group, dtc, recordNumber) == DIA_SUCCESS)
               {
                  DIA_TR_INF("getExtendedData: SUCCESS");
               }
               else
               {
                  DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vProcessRequest pErrorLog->getExtendedData failed");
                  (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
                  vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
               }
            }
            break;
         }// case UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER:

         case UDS_REPORT_READ_SUPPORTED_DTCS:
         {
            if ( dataLength != 3 )
            {
               DIA_TR_INF("UDS_REPORT_READ_SUPPORTED_DTCS: Invalid Length %d<>4",dataLength);
               (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
               vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
            }
            else
            {
               m_u8StatusMask = 0;
               tU8 u8Group = DIAGLOG_MEMORY_CUSTOMER;
               if (vecArgs.size() == 1)
               {
                  u8Group = VoidCast<tU8>(vecArgs[0]);
               }

               if(pErrorLog->getSupportedDTC(u8Group) == DIA_SUCCESS)
               {
                  DIA_TR_INF("getSupportedDTC: SUCCESS");
               }
               else
               {
                  DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vProcessRequest pErrorLog->getSupportedDTC failed");
                  (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
                  vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
               }
            }
            break;
         }// case UDS_REPORT_READ_SUPPORTED_DTCS:

         case UDS_REPORT_READ_LAST_CONFIRMED_DTC:
         {
            if ( dataLength != 4 )
            {
               DIA_TR_INF("UDS_REPORT_READ_LAST_CONFIRMED_DTC: Invalid Length %d<>4",dataLength);
               (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
               vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
            }
            else
            {
               m_u8StatusMask = 0;
               tU8 u8Group = DIAGLOG_MEMORY_CUSTOMER;
               if (vecArgs.size() == 1)
               {
                  u8Group = VoidCast<tU8>(vecArgs[0]);
               }

               if(pErrorLog->getLastConfirmedDTC(u8Group) == DIA_SUCCESS)
               {
                  DIA_TR_INF("getLastConfirmedDTC: SUCCESS");
               }
               else
               {
                  DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vProcessRequest pErrorLog->getLastConfirmedDTC failed");
               (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
                  vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
               }
            }
            break;
         }// case UDS_REPORT_READ_LAST_CONFIRMED_DTC:

         default:
         {
            (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
            vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
            break;
         }
      }
   }
   else
   {
      (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
      DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vProcessRequest querySysAdapterInterface || pErrorLog failed");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}


tVoid
dia_SrvHandlerGenericReadFaultMemory::vOnReadDTCbyStatusMaskResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericReadFaultMemory::vOnReadDTCbyStatusMaskResult");

   (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vOnReadDTCbyStatusMaskResult SUCCESSFUL");

   std::vector<tU8> result;

   result.push_back(UDS_REPORT_DTC_BY_STATUS_MASK);
   result.push_back(u8DTCStatusAvailabilityMask);

   std::list<tdia_IErrorLogResult>::iterator iter = ErrorLogList.begin();
   for ( ; iter != ErrorLogList.end(); iter++ )
   {
      result.push_back((iter->u32DTC >> 16) & 0xFF);
      result.push_back((iter->u32DTC >> 8) & 0xFF);
      result.push_back((iter->u32DTC >> 0) & 0xFF);
      result.push_back(iter->u8Status);
   }

   vSendPositiveResponse((tU16) (1+result.size()), &result);
}


tVoid
dia_SrvHandlerGenericReadFaultMemory::vOnReadNumberOfDTCByStatusMaskResult(const tU8 u8DTCStatusAvailabilityMask, const tU32 u32NumberOfDTC)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericReadFaultMemory::vOnReadDTCbyStatusMaskResult");

   (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vOnReadNumberOfDTCByStatusMaskResult SUCCESSFUL");

   tU8 u8DTCFormatIdentifier = 0x00; //J2012-DADTCF00
   if ( dia_getProperty(DIA_PROP_DTC_FORMAT_IDENTIFIER, u8DTCFormatIdentifier) != DIA_SUCCESS )
   {
      DIA_TR_ERR("!!! dia_SrvHandlerGenericReadFaultMemory: Unable to read ConfigManager property for DTCFormatIdentifier");
   }

   std::vector<tU8> result;

   result.push_back(UDS_REPORT_NUMBER_OF_DTC_BY_STATUS_MASK);
   result.push_back(u8DTCStatusAvailabilityMask);
   result.push_back(u8DTCFormatIdentifier);
   result.push_back((u32NumberOfDTC >> 8) & 0xFF);
   result.push_back((u32NumberOfDTC >> 0) & 0xFF);

   vSendPositiveResponse((tU16) (1+result.size()), &result);
}


#define UDS_DATAID_RES_LENGTH    (2)/* +n variable */

tVoid dia_SrvHandlerGenericReadFaultMemory::vOnDiaglogGetExtendedDataByDTC(IErrorLogExtendedDataResult const& aExtendedData)
{
   dia_tclFnctTrace trc( "dia_SrvHandlerGenericReadFaultMemory::vOnDiaglogGetExtendedDataByDTC");
   (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
   oDiagMsgBuffer().vSetPosResp();
   if (getDID() == UDS_REPORT_DTC_EXTENDED_DATARECORD_BY_DTC_NUMBER)
   {
      oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(UDS_DATAID_RES_LENGTH + (sizeof(tU8) * 3) + sizeof(tU8) + aExtendedData.data.size()));
      oDiagMsgBuffer().vSetDataU8(UDS_DATAID_RES_LENGTH, static_cast<tU8>(aExtendedData.dtc >> 16));
      oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(UDS_DATAID_RES_LENGTH+1), static_cast<tU8>(aExtendedData.dtc >> 8));
      oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(UDS_DATAID_RES_LENGTH+2), static_cast<tU8>(aExtendedData.dtc));
      oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(UDS_DATAID_RES_LENGTH+3), aExtendedData.status);
      for(size_t i = 0; i < aExtendedData.data.size(); ++i)
      {
         oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(UDS_DATAID_RES_LENGTH + 4 + i), aExtendedData.data[i]);
      }
   }
   vResReadyAndQuit();
}


tVoid
dia_SrvHandlerGenericReadFaultMemory::vOnReadSupportedDTCResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericReadFaultMemory::vOnReadSupportedDTCResult");

   (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vOnReadSupportedDTCResult SUCCESSFUL");

   std::vector<tU8> result;

   result.push_back(UDS_REPORT_READ_SUPPORTED_DTCS);
   result.push_back(u8DTCStatusAvailabilityMask);

   std::list<tdia_IErrorLogResult>::iterator iter = ErrorLogList.begin();
   for ( ; iter != ErrorLogList.end(); iter++ )
   {
      result.push_back((iter->u32DTC >> 16) & 0xFF);
      result.push_back((iter->u32DTC >> 8) & 0xFF);
      result.push_back((iter->u32DTC >> 0) & 0xFF);
      result.push_back(iter->u8Status);
   }

   vSendPositiveResponse((tU16) (1+result.size()), &result);
}


tVoid
dia_SrvHandlerGenericReadFaultMemory::vOnReadLastConfirmedDTCResult (const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericReadFaultMemory::vOnReadLastConfirmedDTCResult");

   (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   DIA_TR_INF("dia_SrvHandlerGenericReadFaultMemory::vOnReadLastConfirmedDTCResult SUCCESSFUL");

   std::vector<tU8> result;

   result.push_back(UDS_REPORT_READ_LAST_CONFIRMED_DTC);
   result.push_back(u8DTCStatusAvailabilityMask);

   std::list<tdia_IErrorLogResult>::iterator iter = ErrorLogList.begin();
   for ( ; iter != ErrorLogList.end(); iter++ )
   {
      result.push_back((iter->u32DTC >> 16) & 0xFF);
      result.push_back((iter->u32DTC >> 8) & 0xFF);
      result.push_back((iter->u32DTC >> 0) & 0xFF);
      result.push_back(iter->u8Status);
   }

   vSendPositiveResponse((tU16) (1+result.size()), &result);
}
//-------------------------------------------------------------------------------
tVoid dia_SrvHandlerGenericReadFaultMemory::vOnDiaglogGetSnapShotDataByDTC ( const tU32 dtc, const tU8 status, std::list<IErrorLogSnapshotDataResult>& snapshotList)
{
   dia_tclFnctTrace trc( "dia_SrvHandlerGenericReadFaultMemory::vOnDiaglogGetSnapShotDataByDTC");
   (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
   //oDiagMsgBuffer().vSetPosResp();
   if (getDID() == UDS_REPORT_DTC_SNAPSHOT_RECORD_BY_DTC_NUMBER)
   {
      std::vector<tU8> result;

      result.push_back(UDS_REPORT_DTC_SNAPSHOT_RECORD_BY_DTC_NUMBER);
      result.push_back((dtc>>16) & 0xFF);
      result.push_back((dtc>>8)  & 0xFF);
      result.push_back((dtc)     & 0xFF);
      result.push_back(status);
      std::list<IErrorLogSnapshotDataResult>::iterator iter = snapshotList.begin();
      for ( ; iter != snapshotList.end(); iter++ )
      {
         result.push_back(iter->recNo);
         result.push_back(iter->noOfData);
         std::vector<tU8>::iterator iter2 = iter->data.begin();
         for ( ; iter2 != iter->data.end(); iter2++ )
         {
            result.push_back(*iter2);
         }
      }
      vSendPositiveResponse((tU16) (1+result.size()), &result);
   }
}

//-------------------------------------------------------------------------------
tVoid dia_SrvHandlerGenericReadFaultMemory::vOnDiaglogGetSnapShotId ( std::list<IErrorLogSnapshotIdResult>& snapshotList)
{
   dia_tclFnctTrace trc( "dia_SrvHandlerGenericReadFaultMemory::vOnDiaglogGetSnapShotDataByDTC");
   (tVoid) unsetSysAdapterListener<dia_IErrorLogListener>(this);
   //oDiagMsgBuffer().vSetPosResp();
   if (getDID() == UDS_REPORT_DTC_SNAPSHOT_IDENTIFIER)
   {
      std::vector<tU8> result;

      result.push_back(UDS_REPORT_DTC_SNAPSHOT_IDENTIFIER);

      std::list<IErrorLogSnapshotIdResult>::iterator iter = snapshotList.begin();
      for ( ; iter != snapshotList.end(); iter++ )
      {
         result.push_back(((iter->dtc) >> 16)& 0xFF);
         result.push_back(((iter->dtc) >> 8) & 0xFF);
         result.push_back(((iter->dtc))      & 0xFF);
         result.push_back(iter->recNo);
      }

      vSendPositiveResponse((tU16) (1+result.size()), &result);
   }
}
//-------------------------------------------------------------------------------

tVoid dia_SrvHandlerGenericReadFaultMemory::vOnError ( const dia_ErrorInfoInterface& errInfo )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericReadFaultMemory::vOnError");

   (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   if (errInfo.getExtendedInfoID() == DIA_EN_EXTENDED_RESULT_INFO_ID_INTERFACE)
   {
      if (errInfo.getInterfaceID() == dia_IErrorLogListener::getUID())
      {
         tDiaResult ErrorCode = errInfo.getErrorCode();
         DIA_TR_INF("--- dia_SrvHandlerGenericReadFaultMemory::vOnError => dia_IErrorLogListener: errCode = 0x%x",ErrorCode);

         if (ErrorCode == DIA_E_OUT_OF_RANGE)
         {
            vSendNegativeResponse(DIA_E_U8_UDS_OUT_OF_RANGE);
         }
         else
         {
            vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
         }
      }
      else
      {
         DIA_TR_ERR("!!! dia_SrvHandlerGenericReadFaultMemory::vOnError => ERROR: Unexpected InterfaceID = %d",errInfo.getInterfaceID());
      }
   } //if (errInfo.getExtendedInfoID() == DIA_EN_EXTENDED_RESULT_INFO_ID_INTERFACE)
   else
   {
      DIA_TR_ERR("!!! dia_SrvHandlerGenericReadFaultMemory::vOnError => ERROR: Unexpected ExtendedInfoID = %d",errInfo.getExtendedInfoID());
   }
}


